/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.Status;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * PipelineStatus
 */
@JsonPropertyOrder({
  PipelineStatus.JSON_PROPERTY_EXECUTION_STATUS,
  PipelineStatus.JSON_PROPERTY_TASK_STATUS,
  PipelineStatus.JSON_PROPERTY_TIMESTAMP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class PipelineStatus {
  /**
   * Gets or Sets executionStatus
   */
  public enum ExecutionStatusEnum {
    SUCCESSFUL("Successful"),
    
    FAILED("Failed"),
    
    PENDING("Pending");

    private String value;

    ExecutionStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ExecutionStatusEnum fromValue(String value) {
      for (ExecutionStatusEnum b : ExecutionStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EXECUTION_STATUS = "executionStatus";
  private ExecutionStatusEnum executionStatus;

  public static final String JSON_PROPERTY_TASK_STATUS = "taskStatus";
  private List<Status> taskStatus = null;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp;

  public PipelineStatus() { 
  }

  public PipelineStatus executionStatus(ExecutionStatusEnum executionStatus) {
    
    this.executionStatus = executionStatus;
    return this;
  }

   /**
   * Get executionStatus
   * @return executionStatus
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EXECUTION_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ExecutionStatusEnum getExecutionStatus() {
    return executionStatus;
  }


  @JsonProperty(JSON_PROPERTY_EXECUTION_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExecutionStatus(ExecutionStatusEnum executionStatus) {
    this.executionStatus = executionStatus;
  }


  public PipelineStatus taskStatus(List<Status> taskStatus) {
    
    this.taskStatus = taskStatus;
    return this;
  }

  public PipelineStatus addTaskStatusItem(Status taskStatusItem) {
    if (this.taskStatus == null) {
      this.taskStatus = new ArrayList<>();
    }
    this.taskStatus.add(taskStatusItem);
    return this;
  }

   /**
   * Get taskStatus
   * @return taskStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TASK_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Status> getTaskStatus() {
    return taskStatus;
  }


  @JsonProperty(JSON_PROPERTY_TASK_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaskStatus(List<Status> taskStatus) {
    this.taskStatus = taskStatus;
  }


  public PipelineStatus timestamp(Long timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getTimestamp() {
    return timestamp;
  }


  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineStatus pipelineStatus = (PipelineStatus) o;
    return Objects.equals(this.executionStatus, pipelineStatus.executionStatus) &&
        Objects.equals(this.taskStatus, pipelineStatus.taskStatus) &&
        Objects.equals(this.timestamp, pipelineStatus.timestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(executionStatus, taskStatus, timestamp);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineStatus {\n");
    sb.append("    executionStatus: ").append(toIndentedString(executionStatus)).append("\n");
    sb.append("    taskStatus: ").append(toIndentedString(taskStatus)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

