/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ProfileResult
 */
@JsonPropertyOrder({
  ProfileResult.JSON_PROPERTY_DEBUG_INFO,
  ProfileResult.JSON_PROPERTY_FRAGMENT,
  ProfileResult.JSON_PROPERTY_LUCENE_DESCRIPTION,
  ProfileResult.JSON_PROPERTY_PROFILED_CHILDREN,
  ProfileResult.JSON_PROPERTY_QUERY_NAME,
  ProfileResult.JSON_PROPERTY_TIME,
  ProfileResult.JSON_PROPERTY_TIME_BREAKDOWN
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ProfileResult {
  public static final String JSON_PROPERTY_DEBUG_INFO = "debugInfo";
  private Map<String, Object> debugInfo = null;

  public static final String JSON_PROPERTY_FRAGMENT = "fragment";
  private Boolean fragment;

  public static final String JSON_PROPERTY_LUCENE_DESCRIPTION = "luceneDescription";
  private String luceneDescription;

  public static final String JSON_PROPERTY_PROFILED_CHILDREN = "profiledChildren";
  private List<ProfileResult> profiledChildren = null;

  public static final String JSON_PROPERTY_QUERY_NAME = "queryName";
  private String queryName;

  public static final String JSON_PROPERTY_TIME = "time";
  private Long time;

  public static final String JSON_PROPERTY_TIME_BREAKDOWN = "timeBreakdown";
  private Map<String, Long> timeBreakdown = null;

  public ProfileResult() { 
  }

  public ProfileResult debugInfo(Map<String, Object> debugInfo) {
    
    this.debugInfo = debugInfo;
    return this;
  }

  public ProfileResult putDebugInfoItem(String key, Object debugInfoItem) {
    if (this.debugInfo == null) {
      this.debugInfo = new HashMap<>();
    }
    this.debugInfo.put(key, debugInfoItem);
    return this;
  }

   /**
   * Get debugInfo
   * @return debugInfo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEBUG_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getDebugInfo() {
    return debugInfo;
  }


  @JsonProperty(JSON_PROPERTY_DEBUG_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDebugInfo(Map<String, Object> debugInfo) {
    this.debugInfo = debugInfo;
  }


  public ProfileResult fragment(Boolean fragment) {
    
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFragment() {
    return fragment;
  }


  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }


  public ProfileResult luceneDescription(String luceneDescription) {
    
    this.luceneDescription = luceneDescription;
    return this;
  }

   /**
   * Get luceneDescription
   * @return luceneDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LUCENE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLuceneDescription() {
    return luceneDescription;
  }


  @JsonProperty(JSON_PROPERTY_LUCENE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLuceneDescription(String luceneDescription) {
    this.luceneDescription = luceneDescription;
  }


  public ProfileResult profiledChildren(List<ProfileResult> profiledChildren) {
    
    this.profiledChildren = profiledChildren;
    return this;
  }

  public ProfileResult addProfiledChildrenItem(ProfileResult profiledChildrenItem) {
    if (this.profiledChildren == null) {
      this.profiledChildren = new ArrayList<>();
    }
    this.profiledChildren.add(profiledChildrenItem);
    return this;
  }

   /**
   * Get profiledChildren
   * @return profiledChildren
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILED_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ProfileResult> getProfiledChildren() {
    return profiledChildren;
  }


  @JsonProperty(JSON_PROPERTY_PROFILED_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfiledChildren(List<ProfileResult> profiledChildren) {
    this.profiledChildren = profiledChildren;
  }


  public ProfileResult queryName(String queryName) {
    
    this.queryName = queryName;
    return this;
  }

   /**
   * Get queryName
   * @return queryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUERY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getQueryName() {
    return queryName;
  }


  @JsonProperty(JSON_PROPERTY_QUERY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueryName(String queryName) {
    this.queryName = queryName;
  }


  public ProfileResult time(Long time) {
    
    this.time = time;
    return this;
  }

   /**
   * Get time
   * @return time
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTime() {
    return time;
  }


  @JsonProperty(JSON_PROPERTY_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTime(Long time) {
    this.time = time;
  }


  public ProfileResult timeBreakdown(Map<String, Long> timeBreakdown) {
    
    this.timeBreakdown = timeBreakdown;
    return this;
  }

  public ProfileResult putTimeBreakdownItem(String key, Long timeBreakdownItem) {
    if (this.timeBreakdown == null) {
      this.timeBreakdown = new HashMap<>();
    }
    this.timeBreakdown.put(key, timeBreakdownItem);
    return this;
  }

   /**
   * Get timeBreakdown
   * @return timeBreakdown
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIME_BREAKDOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Long> getTimeBreakdown() {
    return timeBreakdown;
  }


  @JsonProperty(JSON_PROPERTY_TIME_BREAKDOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeBreakdown(Map<String, Long> timeBreakdown) {
    this.timeBreakdown = timeBreakdown;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProfileResult profileResult = (ProfileResult) o;
    return Objects.equals(this.debugInfo, profileResult.debugInfo) &&
        Objects.equals(this.fragment, profileResult.fragment) &&
        Objects.equals(this.luceneDescription, profileResult.luceneDescription) &&
        Objects.equals(this.profiledChildren, profileResult.profiledChildren) &&
        Objects.equals(this.queryName, profileResult.queryName) &&
        Objects.equals(this.time, profileResult.time) &&
        Objects.equals(this.timeBreakdown, profileResult.timeBreakdown);
  }

  @Override
  public int hashCode() {
    return Objects.hash(debugInfo, fragment, luceneDescription, profiledChildren, queryName, time, timeBreakdown);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProfileResult {\n");
    sb.append("    debugInfo: ").append(toIndentedString(debugInfo)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    luceneDescription: ").append(toIndentedString(luceneDescription)).append("\n");
    sb.append("    profiledChildren: ").append(toIndentedString(profiledChildren)).append("\n");
    sb.append("    queryName: ").append(toIndentedString(queryName)).append("\n");
    sb.append("    time: ").append(toIndentedString(time)).append("\n");
    sb.append("    timeBreakdown: ").append(toIndentedString(timeBreakdown)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

