/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.client.model.ScheduleApplication200ResponseCookiesValue;
import org.openmetadata.client.model.ScheduleApplication200ResponseEntityTag;
import org.openmetadata.client.model.ScheduleApplication200ResponseLanguage;
import org.openmetadata.client.model.ScheduleApplication200ResponseLinksInner;
import org.openmetadata.client.model.ScheduleApplication200ResponseMediaType;
import org.openmetadata.client.model.ScheduleApplication200ResponseStatusInfo;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ScheduleApplication200Response
 */
@JsonPropertyOrder({
  ScheduleApplication200Response.JSON_PROPERTY_LENGTH,
  ScheduleApplication200Response.JSON_PROPERTY_LOCATION,
  ScheduleApplication200Response.JSON_PROPERTY_LANGUAGE,
  ScheduleApplication200Response.JSON_PROPERTY_DATE,
  ScheduleApplication200Response.JSON_PROPERTY_LAST_MODIFIED,
  ScheduleApplication200Response.JSON_PROPERTY_METADATA,
  ScheduleApplication200Response.JSON_PROPERTY_STATUS,
  ScheduleApplication200Response.JSON_PROPERTY_ENTITY,
  ScheduleApplication200Response.JSON_PROPERTY_COOKIES,
  ScheduleApplication200Response.JSON_PROPERTY_MEDIA_TYPE,
  ScheduleApplication200Response.JSON_PROPERTY_LINKS,
  ScheduleApplication200Response.JSON_PROPERTY_ENTITY_TAG,
  ScheduleApplication200Response.JSON_PROPERTY_STATUS_INFO,
  ScheduleApplication200Response.JSON_PROPERTY_ALLOWED_METHODS,
  ScheduleApplication200Response.JSON_PROPERTY_STRING_HEADERS,
  ScheduleApplication200Response.JSON_PROPERTY_HEADERS
})
@JsonTypeName("scheduleApplication_200_response")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ScheduleApplication200Response {
  public static final String JSON_PROPERTY_LENGTH = "length";
  private Integer length;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private URI location;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private ScheduleApplication200ResponseLanguage language;

  public static final String JSON_PROPERTY_DATE = "date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
  private OffsetDateTime lastModified;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, List<Object>> metadata = null;

  public static final String JSON_PROPERTY_STATUS = "status";
  private Integer status;

  public static final String JSON_PROPERTY_ENTITY = "entity";
  private Object entity;

  public static final String JSON_PROPERTY_COOKIES = "cookies";
  private Map<String, ScheduleApplication200ResponseCookiesValue> cookies = null;

  public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
  private ScheduleApplication200ResponseMediaType mediaType;

  public static final String JSON_PROPERTY_LINKS = "links";
  private Set<ScheduleApplication200ResponseLinksInner> links = null;

  public static final String JSON_PROPERTY_ENTITY_TAG = "entityTag";
  private ScheduleApplication200ResponseEntityTag entityTag;

  public static final String JSON_PROPERTY_STATUS_INFO = "statusInfo";
  private ScheduleApplication200ResponseStatusInfo statusInfo;

  public static final String JSON_PROPERTY_ALLOWED_METHODS = "allowedMethods";
  private Set<String> allowedMethods = null;

  public static final String JSON_PROPERTY_STRING_HEADERS = "stringHeaders";
  private Map<String, List<String>> stringHeaders = null;

  public static final String JSON_PROPERTY_HEADERS = "headers";
  private Map<String, List<Object>> headers = null;

  public ScheduleApplication200Response() { 
  }

  public ScheduleApplication200Response length(Integer length) {
    
    this.length = length;
    return this;
  }

   /**
   * Get length
   * @return length
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLength() {
    return length;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLength(Integer length) {
    this.length = length;
  }


  public ScheduleApplication200Response location(URI location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(URI location) {
    this.location = location;
  }


  public ScheduleApplication200Response language(ScheduleApplication200ResponseLanguage language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ScheduleApplication200ResponseLanguage getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(ScheduleApplication200ResponseLanguage language) {
    this.language = language;
  }


  public ScheduleApplication200Response date(OffsetDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public ScheduleApplication200Response lastModified(OffsetDateTime lastModified) {
    
    this.lastModified = lastModified;
    return this;
  }

   /**
   * Get lastModified
   * @return lastModified
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastModified() {
    return lastModified;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastModified(OffsetDateTime lastModified) {
    this.lastModified = lastModified;
  }


  public ScheduleApplication200Response metadata(Map<String, List<Object>> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public ScheduleApplication200Response putMetadataItem(String key, List<Object> metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, List<Object>> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, List<Object>> metadata) {
    this.metadata = metadata;
  }


  public ScheduleApplication200Response status(Integer status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(Integer status) {
    this.status = status;
  }


  public ScheduleApplication200Response entity(Object entity) {
    
    this.entity = entity;
    return this;
  }

   /**
   * Get entity
   * @return entity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getEntity() {
    return entity;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntity(Object entity) {
    this.entity = entity;
  }


  public ScheduleApplication200Response cookies(Map<String, ScheduleApplication200ResponseCookiesValue> cookies) {
    
    this.cookies = cookies;
    return this;
  }

  public ScheduleApplication200Response putCookiesItem(String key, ScheduleApplication200ResponseCookiesValue cookiesItem) {
    if (this.cookies == null) {
      this.cookies = new HashMap<>();
    }
    this.cookies.put(key, cookiesItem);
    return this;
  }

   /**
   * Get cookies
   * @return cookies
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COOKIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, ScheduleApplication200ResponseCookiesValue> getCookies() {
    return cookies;
  }


  @JsonProperty(JSON_PROPERTY_COOKIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCookies(Map<String, ScheduleApplication200ResponseCookiesValue> cookies) {
    this.cookies = cookies;
  }


  public ScheduleApplication200Response mediaType(ScheduleApplication200ResponseMediaType mediaType) {
    
    this.mediaType = mediaType;
    return this;
  }

   /**
   * Get mediaType
   * @return mediaType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEDIA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ScheduleApplication200ResponseMediaType getMediaType() {
    return mediaType;
  }


  @JsonProperty(JSON_PROPERTY_MEDIA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMediaType(ScheduleApplication200ResponseMediaType mediaType) {
    this.mediaType = mediaType;
  }


  public ScheduleApplication200Response links(Set<ScheduleApplication200ResponseLinksInner> links) {
    
    this.links = links;
    return this;
  }

  public ScheduleApplication200Response addLinksItem(ScheduleApplication200ResponseLinksInner linksItem) {
    if (this.links == null) {
      this.links = new LinkedHashSet<>();
    }
    this.links.add(linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<ScheduleApplication200ResponseLinksInner> getLinks() {
    return links;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Set<ScheduleApplication200ResponseLinksInner> links) {
    this.links = links;
  }


  public ScheduleApplication200Response entityTag(ScheduleApplication200ResponseEntityTag entityTag) {
    
    this.entityTag = entityTag;
    return this;
  }

   /**
   * Get entityTag
   * @return entityTag
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ScheduleApplication200ResponseEntityTag getEntityTag() {
    return entityTag;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityTag(ScheduleApplication200ResponseEntityTag entityTag) {
    this.entityTag = entityTag;
  }


  public ScheduleApplication200Response statusInfo(ScheduleApplication200ResponseStatusInfo statusInfo) {
    
    this.statusInfo = statusInfo;
    return this;
  }

   /**
   * Get statusInfo
   * @return statusInfo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ScheduleApplication200ResponseStatusInfo getStatusInfo() {
    return statusInfo;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusInfo(ScheduleApplication200ResponseStatusInfo statusInfo) {
    this.statusInfo = statusInfo;
  }


  public ScheduleApplication200Response allowedMethods(Set<String> allowedMethods) {
    
    this.allowedMethods = allowedMethods;
    return this;
  }

  public ScheduleApplication200Response addAllowedMethodsItem(String allowedMethodsItem) {
    if (this.allowedMethods == null) {
      this.allowedMethods = new LinkedHashSet<>();
    }
    this.allowedMethods.add(allowedMethodsItem);
    return this;
  }

   /**
   * Get allowedMethods
   * @return allowedMethods
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ALLOWED_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getAllowedMethods() {
    return allowedMethods;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_ALLOWED_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedMethods(Set<String> allowedMethods) {
    this.allowedMethods = allowedMethods;
  }


  public ScheduleApplication200Response stringHeaders(Map<String, List<String>> stringHeaders) {
    
    this.stringHeaders = stringHeaders;
    return this;
  }

  public ScheduleApplication200Response putStringHeadersItem(String key, List<String> stringHeadersItem) {
    if (this.stringHeaders == null) {
      this.stringHeaders = new HashMap<>();
    }
    this.stringHeaders.put(key, stringHeadersItem);
    return this;
  }

   /**
   * Get stringHeaders
   * @return stringHeaders
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STRING_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, List<String>> getStringHeaders() {
    return stringHeaders;
  }


  @JsonProperty(JSON_PROPERTY_STRING_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStringHeaders(Map<String, List<String>> stringHeaders) {
    this.stringHeaders = stringHeaders;
  }


  public ScheduleApplication200Response headers(Map<String, List<Object>> headers) {
    
    this.headers = headers;
    return this;
  }

  public ScheduleApplication200Response putHeadersItem(String key, List<Object> headersItem) {
    if (this.headers == null) {
      this.headers = new HashMap<>();
    }
    this.headers.put(key, headersItem);
    return this;
  }

   /**
   * Get headers
   * @return headers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, List<Object>> getHeaders() {
    return headers;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaders(Map<String, List<Object>> headers) {
    this.headers = headers;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleApplication200Response scheduleApplication200Response = (ScheduleApplication200Response) o;
    return Objects.equals(this.length, scheduleApplication200Response.length) &&
        Objects.equals(this.location, scheduleApplication200Response.location) &&
        Objects.equals(this.language, scheduleApplication200Response.language) &&
        Objects.equals(this.date, scheduleApplication200Response.date) &&
        Objects.equals(this.lastModified, scheduleApplication200Response.lastModified) &&
        Objects.equals(this.metadata, scheduleApplication200Response.metadata) &&
        Objects.equals(this.status, scheduleApplication200Response.status) &&
        Objects.equals(this.entity, scheduleApplication200Response.entity) &&
        Objects.equals(this.cookies, scheduleApplication200Response.cookies) &&
        Objects.equals(this.mediaType, scheduleApplication200Response.mediaType) &&
        Objects.equals(this.links, scheduleApplication200Response.links) &&
        Objects.equals(this.entityTag, scheduleApplication200Response.entityTag) &&
        Objects.equals(this.statusInfo, scheduleApplication200Response.statusInfo) &&
        Objects.equals(this.allowedMethods, scheduleApplication200Response.allowedMethods) &&
        Objects.equals(this.stringHeaders, scheduleApplication200Response.stringHeaders) &&
        Objects.equals(this.headers, scheduleApplication200Response.headers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(length, location, language, date, lastModified, metadata, status, entity, cookies, mediaType, links, entityTag, statusInfo, allowedMethods, stringHeaders, headers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleApplication200Response {\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    lastModified: ").append(toIndentedString(lastModified)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    cookies: ").append(toIndentedString(cookies)).append("\n");
    sb.append("    mediaType: ").append(toIndentedString(mediaType)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    entityTag: ").append(toIndentedString(entityTag)).append("\n");
    sb.append("    statusInfo: ").append(toIndentedString(statusInfo)).append("\n");
    sb.append("    allowedMethods: ").append(toIndentedString(allowedMethods)).append("\n");
    sb.append("    stringHeaders: ").append(toIndentedString(stringHeaders)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

