/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ScheduleApplication200ResponseLanguage
 */
@JsonPropertyOrder({
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_LANGUAGE,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_DISPLAY_NAME,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_COUNTRY,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_VARIANT,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_SCRIPT,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_UNICODE_LOCALE_ATTRIBUTES,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_UNICODE_LOCALE_KEYS,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_DISPLAY_LANGUAGE,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_DISPLAY_SCRIPT,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_DISPLAY_COUNTRY,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_DISPLAY_VARIANT,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_EXTENSION_KEYS,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_ISO3_LANGUAGE,
  ScheduleApplication200ResponseLanguage.JSON_PROPERTY_ISO3_COUNTRY
})
@JsonTypeName("scheduleApplication_200_response_language")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ScheduleApplication200ResponseLanguage {
  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_VARIANT = "variant";
  private String variant;

  public static final String JSON_PROPERTY_SCRIPT = "script";
  private String script;

  public static final String JSON_PROPERTY_UNICODE_LOCALE_ATTRIBUTES = "unicodeLocaleAttributes";
  private Set<String> unicodeLocaleAttributes = null;

  public static final String JSON_PROPERTY_UNICODE_LOCALE_KEYS = "unicodeLocaleKeys";
  private Set<String> unicodeLocaleKeys = null;

  public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
  private String displayLanguage;

  public static final String JSON_PROPERTY_DISPLAY_SCRIPT = "displayScript";
  private String displayScript;

  public static final String JSON_PROPERTY_DISPLAY_COUNTRY = "displayCountry";
  private String displayCountry;

  public static final String JSON_PROPERTY_DISPLAY_VARIANT = "displayVariant";
  private String displayVariant;

  public static final String JSON_PROPERTY_EXTENSION_KEYS = "extensionKeys";
  private Set<String> extensionKeys = null;

  public static final String JSON_PROPERTY_ISO3_LANGUAGE = "iso3Language";
  private String iso3Language;

  public static final String JSON_PROPERTY_ISO3_COUNTRY = "iso3Country";
  private String iso3Country;

  public ScheduleApplication200ResponseLanguage() { 
  }

  public ScheduleApplication200ResponseLanguage language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public ScheduleApplication200ResponseLanguage displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public ScheduleApplication200ResponseLanguage country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public ScheduleApplication200ResponseLanguage variant(String variant) {
    
    this.variant = variant;
    return this;
  }

   /**
   * Get variant
   * @return variant
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVariant() {
    return variant;
  }


  @JsonProperty(JSON_PROPERTY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariant(String variant) {
    this.variant = variant;
  }


  public ScheduleApplication200ResponseLanguage script(String script) {
    
    this.script = script;
    return this;
  }

   /**
   * Get script
   * @return script
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScript() {
    return script;
  }


  @JsonProperty(JSON_PROPERTY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScript(String script) {
    this.script = script;
  }


  public ScheduleApplication200ResponseLanguage unicodeLocaleAttributes(Set<String> unicodeLocaleAttributes) {
    
    this.unicodeLocaleAttributes = unicodeLocaleAttributes;
    return this;
  }

  public ScheduleApplication200ResponseLanguage addUnicodeLocaleAttributesItem(String unicodeLocaleAttributesItem) {
    if (this.unicodeLocaleAttributes == null) {
      this.unicodeLocaleAttributes = new LinkedHashSet<>();
    }
    this.unicodeLocaleAttributes.add(unicodeLocaleAttributesItem);
    return this;
  }

   /**
   * Get unicodeLocaleAttributes
   * @return unicodeLocaleAttributes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNICODE_LOCALE_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getUnicodeLocaleAttributes() {
    return unicodeLocaleAttributes;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_UNICODE_LOCALE_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnicodeLocaleAttributes(Set<String> unicodeLocaleAttributes) {
    this.unicodeLocaleAttributes = unicodeLocaleAttributes;
  }


  public ScheduleApplication200ResponseLanguage unicodeLocaleKeys(Set<String> unicodeLocaleKeys) {
    
    this.unicodeLocaleKeys = unicodeLocaleKeys;
    return this;
  }

  public ScheduleApplication200ResponseLanguage addUnicodeLocaleKeysItem(String unicodeLocaleKeysItem) {
    if (this.unicodeLocaleKeys == null) {
      this.unicodeLocaleKeys = new LinkedHashSet<>();
    }
    this.unicodeLocaleKeys.add(unicodeLocaleKeysItem);
    return this;
  }

   /**
   * Get unicodeLocaleKeys
   * @return unicodeLocaleKeys
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNICODE_LOCALE_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getUnicodeLocaleKeys() {
    return unicodeLocaleKeys;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_UNICODE_LOCALE_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnicodeLocaleKeys(Set<String> unicodeLocaleKeys) {
    this.unicodeLocaleKeys = unicodeLocaleKeys;
  }


  public ScheduleApplication200ResponseLanguage displayLanguage(String displayLanguage) {
    
    this.displayLanguage = displayLanguage;
    return this;
  }

   /**
   * Get displayLanguage
   * @return displayLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayLanguage() {
    return displayLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayLanguage(String displayLanguage) {
    this.displayLanguage = displayLanguage;
  }


  public ScheduleApplication200ResponseLanguage displayScript(String displayScript) {
    
    this.displayScript = displayScript;
    return this;
  }

   /**
   * Get displayScript
   * @return displayScript
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayScript() {
    return displayScript;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_SCRIPT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayScript(String displayScript) {
    this.displayScript = displayScript;
  }


  public ScheduleApplication200ResponseLanguage displayCountry(String displayCountry) {
    
    this.displayCountry = displayCountry;
    return this;
  }

   /**
   * Get displayCountry
   * @return displayCountry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCountry() {
    return displayCountry;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCountry(String displayCountry) {
    this.displayCountry = displayCountry;
  }


  public ScheduleApplication200ResponseLanguage displayVariant(String displayVariant) {
    
    this.displayVariant = displayVariant;
    return this;
  }

   /**
   * Get displayVariant
   * @return displayVariant
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayVariant() {
    return displayVariant;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_VARIANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayVariant(String displayVariant) {
    this.displayVariant = displayVariant;
  }


  public ScheduleApplication200ResponseLanguage extensionKeys(Set<String> extensionKeys) {
    
    this.extensionKeys = extensionKeys;
    return this;
  }

  public ScheduleApplication200ResponseLanguage addExtensionKeysItem(String extensionKeysItem) {
    if (this.extensionKeys == null) {
      this.extensionKeys = new LinkedHashSet<>();
    }
    this.extensionKeys.add(extensionKeysItem);
    return this;
  }

   /**
   * Get extensionKeys
   * @return extensionKeys
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getExtensionKeys() {
    return extensionKeys;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_EXTENSION_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtensionKeys(Set<String> extensionKeys) {
    this.extensionKeys = extensionKeys;
  }


  public ScheduleApplication200ResponseLanguage iso3Language(String iso3Language) {
    
    this.iso3Language = iso3Language;
    return this;
  }

   /**
   * Get iso3Language
   * @return iso3Language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Language() {
    return iso3Language;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Language(String iso3Language) {
    this.iso3Language = iso3Language;
  }


  public ScheduleApplication200ResponseLanguage iso3Country(String iso3Country) {
    
    this.iso3Country = iso3Country;
    return this;
  }

   /**
   * Get iso3Country
   * @return iso3Country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3Country() {
    return iso3Country;
  }


  @JsonProperty(JSON_PROPERTY_ISO3_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3Country(String iso3Country) {
    this.iso3Country = iso3Country;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleApplication200ResponseLanguage scheduleApplication200ResponseLanguage = (ScheduleApplication200ResponseLanguage) o;
    return Objects.equals(this.language, scheduleApplication200ResponseLanguage.language) &&
        Objects.equals(this.displayName, scheduleApplication200ResponseLanguage.displayName) &&
        Objects.equals(this.country, scheduleApplication200ResponseLanguage.country) &&
        Objects.equals(this.variant, scheduleApplication200ResponseLanguage.variant) &&
        Objects.equals(this.script, scheduleApplication200ResponseLanguage.script) &&
        Objects.equals(this.unicodeLocaleAttributes, scheduleApplication200ResponseLanguage.unicodeLocaleAttributes) &&
        Objects.equals(this.unicodeLocaleKeys, scheduleApplication200ResponseLanguage.unicodeLocaleKeys) &&
        Objects.equals(this.displayLanguage, scheduleApplication200ResponseLanguage.displayLanguage) &&
        Objects.equals(this.displayScript, scheduleApplication200ResponseLanguage.displayScript) &&
        Objects.equals(this.displayCountry, scheduleApplication200ResponseLanguage.displayCountry) &&
        Objects.equals(this.displayVariant, scheduleApplication200ResponseLanguage.displayVariant) &&
        Objects.equals(this.extensionKeys, scheduleApplication200ResponseLanguage.extensionKeys) &&
        Objects.equals(this.iso3Language, scheduleApplication200ResponseLanguage.iso3Language) &&
        Objects.equals(this.iso3Country, scheduleApplication200ResponseLanguage.iso3Country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(language, displayName, country, variant, script, unicodeLocaleAttributes, unicodeLocaleKeys, displayLanguage, displayScript, displayCountry, displayVariant, extensionKeys, iso3Language, iso3Country);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleApplication200ResponseLanguage {\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    variant: ").append(toIndentedString(variant)).append("\n");
    sb.append("    script: ").append(toIndentedString(script)).append("\n");
    sb.append("    unicodeLocaleAttributes: ").append(toIndentedString(unicodeLocaleAttributes)).append("\n");
    sb.append("    unicodeLocaleKeys: ").append(toIndentedString(unicodeLocaleKeys)).append("\n");
    sb.append("    displayLanguage: ").append(toIndentedString(displayLanguage)).append("\n");
    sb.append("    displayScript: ").append(toIndentedString(displayScript)).append("\n");
    sb.append("    displayCountry: ").append(toIndentedString(displayCountry)).append("\n");
    sb.append("    displayVariant: ").append(toIndentedString(displayVariant)).append("\n");
    sb.append("    extensionKeys: ").append(toIndentedString(extensionKeys)).append("\n");
    sb.append("    iso3Language: ").append(toIndentedString(iso3Language)).append("\n");
    sb.append("    iso3Country: ").append(toIndentedString(iso3Country)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

