/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ScheduleApplication200ResponseLinksInner
 */
@JsonPropertyOrder({
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_TYPE,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_PARAMS,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_URI,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_TITLE,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_URI_BUILDER,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_REL,
  ScheduleApplication200ResponseLinksInner.JSON_PROPERTY_RELS
})
@JsonTypeName("scheduleApplication_200_response_links_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ScheduleApplication200ResponseLinksInner {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_PARAMS = "params";
  private Map<String, String> params = null;

  public static final String JSON_PROPERTY_URI = "uri";
  private URI uri;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_URI_BUILDER = "uriBuilder";
  private Object uriBuilder;

  public static final String JSON_PROPERTY_REL = "rel";
  private String rel;

  public static final String JSON_PROPERTY_RELS = "rels";
  private List<String> rels = null;

  public ScheduleApplication200ResponseLinksInner() { 
  }

  public ScheduleApplication200ResponseLinksInner type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public ScheduleApplication200ResponseLinksInner params(Map<String, String> params) {
    
    this.params = params;
    return this;
  }

  public ScheduleApplication200ResponseLinksInner putParamsItem(String key, String paramsItem) {
    if (this.params == null) {
      this.params = new HashMap<>();
    }
    this.params.put(key, paramsItem);
    return this;
  }

   /**
   * Get params
   * @return params
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getParams() {
    return params;
  }


  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParams(Map<String, String> params) {
    this.params = params;
  }


  public ScheduleApplication200ResponseLinksInner uri(URI uri) {
    
    this.uri = uri;
    return this;
  }

   /**
   * Get uri
   * @return uri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getUri() {
    return uri;
  }


  @JsonProperty(JSON_PROPERTY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUri(URI uri) {
    this.uri = uri;
  }


  public ScheduleApplication200ResponseLinksInner title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public ScheduleApplication200ResponseLinksInner uriBuilder(Object uriBuilder) {
    
    this.uriBuilder = uriBuilder;
    return this;
  }

   /**
   * Get uriBuilder
   * @return uriBuilder
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_URI_BUILDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getUriBuilder() {
    return uriBuilder;
  }


  @JsonProperty(JSON_PROPERTY_URI_BUILDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUriBuilder(Object uriBuilder) {
    this.uriBuilder = uriBuilder;
  }


  public ScheduleApplication200ResponseLinksInner rel(String rel) {
    
    this.rel = rel;
    return this;
  }

   /**
   * Get rel
   * @return rel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRel() {
    return rel;
  }


  @JsonProperty(JSON_PROPERTY_REL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRel(String rel) {
    this.rel = rel;
  }


  public ScheduleApplication200ResponseLinksInner rels(List<String> rels) {
    
    this.rels = rels;
    return this;
  }

  public ScheduleApplication200ResponseLinksInner addRelsItem(String relsItem) {
    if (this.rels == null) {
      this.rels = new ArrayList<>();
    }
    this.rels.add(relsItem);
    return this;
  }

   /**
   * Get rels
   * @return rels
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRels() {
    return rels;
  }


  @JsonProperty(JSON_PROPERTY_RELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRels(List<String> rels) {
    this.rels = rels;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleApplication200ResponseLinksInner scheduleApplication200ResponseLinksInner = (ScheduleApplication200ResponseLinksInner) o;
    return Objects.equals(this.type, scheduleApplication200ResponseLinksInner.type) &&
        Objects.equals(this.params, scheduleApplication200ResponseLinksInner.params) &&
        Objects.equals(this.uri, scheduleApplication200ResponseLinksInner.uri) &&
        Objects.equals(this.title, scheduleApplication200ResponseLinksInner.title) &&
        Objects.equals(this.uriBuilder, scheduleApplication200ResponseLinksInner.uriBuilder) &&
        Objects.equals(this.rel, scheduleApplication200ResponseLinksInner.rel) &&
        Objects.equals(this.rels, scheduleApplication200ResponseLinksInner.rels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, params, uri, title, uriBuilder, rel, rels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleApplication200ResponseLinksInner {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    uriBuilder: ").append(toIndentedString(uriBuilder)).append("\n");
    sb.append("    rel: ").append(toIndentedString(rel)).append("\n");
    sb.append("    rels: ").append(toIndentedString(rels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

