/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.client.model.BytesReference;
import org.openmetadata.client.model.DocumentField;
import org.openmetadata.client.model.Explanation;
import org.openmetadata.client.model.HighlightField;
import org.openmetadata.client.model.NestedIdentity;
import org.openmetadata.client.model.SearchHits;
import org.openmetadata.client.model.SearchShardTarget;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * SearchHit
 */
@JsonPropertyOrder({
  SearchHit.JSON_PROPERTY_CLUSTER_ALIAS,
  SearchHit.JSON_PROPERTY_DOCUMENT_FIELDS,
  SearchHit.JSON_PROPERTY_EXPLANATION,
  SearchHit.JSON_PROPERTY_FIELDS,
  SearchHit.JSON_PROPERTY_FRAGMENT,
  SearchHit.JSON_PROPERTY_HIGHLIGHT_FIELDS,
  SearchHit.JSON_PROPERTY_ID,
  SearchHit.JSON_PROPERTY_INDEX,
  SearchHit.JSON_PROPERTY_INNER_HITS,
  SearchHit.JSON_PROPERTY_MATCHED_QUERIES,
  SearchHit.JSON_PROPERTY_METADATA_FIELDS,
  SearchHit.JSON_PROPERTY_NESTED_IDENTITY,
  SearchHit.JSON_PROPERTY_PRIMARY_TERM,
  SearchHit.JSON_PROPERTY_RAW_SORT_VALUES,
  SearchHit.JSON_PROPERTY_SCORE,
  SearchHit.JSON_PROPERTY_SEQ_NO,
  SearchHit.JSON_PROPERTY_SHARD,
  SearchHit.JSON_PROPERTY_SORT_VALUES,
  SearchHit.JSON_PROPERTY_SOURCE_AS_MAP,
  SearchHit.JSON_PROPERTY_SOURCE_AS_STRING,
  SearchHit.JSON_PROPERTY_SOURCE_REF,
  SearchHit.JSON_PROPERTY_TYPE,
  SearchHit.JSON_PROPERTY_VERSION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class SearchHit {
  public static final String JSON_PROPERTY_CLUSTER_ALIAS = "clusterAlias";
  private String clusterAlias;

  public static final String JSON_PROPERTY_DOCUMENT_FIELDS = "documentFields";
  private Map<String, DocumentField> documentFields = null;

  public static final String JSON_PROPERTY_EXPLANATION = "explanation";
  private Explanation explanation;

  public static final String JSON_PROPERTY_FIELDS = "fields";
  private Map<String, DocumentField> fields = null;

  public static final String JSON_PROPERTY_FRAGMENT = "fragment";
  private Boolean fragment;

  public static final String JSON_PROPERTY_HIGHLIGHT_FIELDS = "highlightFields";
  private Map<String, HighlightField> highlightFields = null;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INDEX = "index";
  private String index;

  public static final String JSON_PROPERTY_INNER_HITS = "innerHits";
  private Map<String, SearchHits> innerHits = null;

  public static final String JSON_PROPERTY_MATCHED_QUERIES = "matchedQueries";
  private List<String> matchedQueries = null;

  public static final String JSON_PROPERTY_METADATA_FIELDS = "metadataFields";
  private Map<String, DocumentField> metadataFields = null;

  public static final String JSON_PROPERTY_NESTED_IDENTITY = "nestedIdentity";
  private NestedIdentity nestedIdentity;

  public static final String JSON_PROPERTY_PRIMARY_TERM = "primaryTerm";
  private Long primaryTerm;

  public static final String JSON_PROPERTY_RAW_SORT_VALUES = "rawSortValues";
  private List<Object> rawSortValues = null;

  public static final String JSON_PROPERTY_SCORE = "score";
  private Float score;

  public static final String JSON_PROPERTY_SEQ_NO = "seqNo";
  private Long seqNo;

  public static final String JSON_PROPERTY_SHARD = "shard";
  private SearchShardTarget shard;

  public static final String JSON_PROPERTY_SORT_VALUES = "sortValues";
  private List<Object> sortValues = null;

  public static final String JSON_PROPERTY_SOURCE_AS_MAP = "sourceAsMap";
  private Map<String, Object> sourceAsMap = null;

  public static final String JSON_PROPERTY_SOURCE_AS_STRING = "sourceAsString";
  private String sourceAsString;

  public static final String JSON_PROPERTY_SOURCE_REF = "sourceRef";
  private BytesReference sourceRef;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public SearchHit() { 
  }

  public SearchHit clusterAlias(String clusterAlias) {
    
    this.clusterAlias = clusterAlias;
    return this;
  }

   /**
   * Get clusterAlias
   * @return clusterAlias
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLUSTER_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClusterAlias() {
    return clusterAlias;
  }


  @JsonProperty(JSON_PROPERTY_CLUSTER_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusterAlias(String clusterAlias) {
    this.clusterAlias = clusterAlias;
  }


  public SearchHit documentFields(Map<String, DocumentField> documentFields) {
    
    this.documentFields = documentFields;
    return this;
  }

  public SearchHit putDocumentFieldsItem(String key, DocumentField documentFieldsItem) {
    if (this.documentFields == null) {
      this.documentFields = new HashMap<>();
    }
    this.documentFields.put(key, documentFieldsItem);
    return this;
  }

   /**
   * Get documentFields
   * @return documentFields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOCUMENT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, DocumentField> getDocumentFields() {
    return documentFields;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentFields(Map<String, DocumentField> documentFields) {
    this.documentFields = documentFields;
  }


  public SearchHit explanation(Explanation explanation) {
    
    this.explanation = explanation;
    return this;
  }

   /**
   * Get explanation
   * @return explanation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPLANATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Explanation getExplanation() {
    return explanation;
  }


  @JsonProperty(JSON_PROPERTY_EXPLANATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExplanation(Explanation explanation) {
    this.explanation = explanation;
  }


  public SearchHit fields(Map<String, DocumentField> fields) {
    
    this.fields = fields;
    return this;
  }

  public SearchHit putFieldsItem(String key, DocumentField fieldsItem) {
    if (this.fields == null) {
      this.fields = new HashMap<>();
    }
    this.fields.put(key, fieldsItem);
    return this;
  }

   /**
   * Get fields
   * @return fields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, DocumentField> getFields() {
    return fields;
  }


  @JsonProperty(JSON_PROPERTY_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFields(Map<String, DocumentField> fields) {
    this.fields = fields;
  }


  public SearchHit fragment(Boolean fragment) {
    
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFragment() {
    return fragment;
  }


  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }


  public SearchHit highlightFields(Map<String, HighlightField> highlightFields) {
    
    this.highlightFields = highlightFields;
    return this;
  }

  public SearchHit putHighlightFieldsItem(String key, HighlightField highlightFieldsItem) {
    if (this.highlightFields == null) {
      this.highlightFields = new HashMap<>();
    }
    this.highlightFields.put(key, highlightFieldsItem);
    return this;
  }

   /**
   * Get highlightFields
   * @return highlightFields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HIGHLIGHT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, HighlightField> getHighlightFields() {
    return highlightFields;
  }


  @JsonProperty(JSON_PROPERTY_HIGHLIGHT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHighlightFields(Map<String, HighlightField> highlightFields) {
    this.highlightFields = highlightFields;
  }


  public SearchHit id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public SearchHit index(String index) {
    
    this.index = index;
    return this;
  }

   /**
   * Get index
   * @return index
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndex() {
    return index;
  }


  @JsonProperty(JSON_PROPERTY_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndex(String index) {
    this.index = index;
  }


  public SearchHit innerHits(Map<String, SearchHits> innerHits) {
    
    this.innerHits = innerHits;
    return this;
  }

  public SearchHit putInnerHitsItem(String key, SearchHits innerHitsItem) {
    if (this.innerHits == null) {
      this.innerHits = new HashMap<>();
    }
    this.innerHits.put(key, innerHitsItem);
    return this;
  }

   /**
   * Get innerHits
   * @return innerHits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INNER_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, SearchHits> getInnerHits() {
    return innerHits;
  }


  @JsonProperty(JSON_PROPERTY_INNER_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInnerHits(Map<String, SearchHits> innerHits) {
    this.innerHits = innerHits;
  }


  public SearchHit matchedQueries(List<String> matchedQueries) {
    
    this.matchedQueries = matchedQueries;
    return this;
  }

  public SearchHit addMatchedQueriesItem(String matchedQueriesItem) {
    if (this.matchedQueries == null) {
      this.matchedQueries = new ArrayList<>();
    }
    this.matchedQueries.add(matchedQueriesItem);
    return this;
  }

   /**
   * Get matchedQueries
   * @return matchedQueries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MATCHED_QUERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMatchedQueries() {
    return matchedQueries;
  }


  @JsonProperty(JSON_PROPERTY_MATCHED_QUERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMatchedQueries(List<String> matchedQueries) {
    this.matchedQueries = matchedQueries;
  }


  public SearchHit metadataFields(Map<String, DocumentField> metadataFields) {
    
    this.metadataFields = metadataFields;
    return this;
  }

  public SearchHit putMetadataFieldsItem(String key, DocumentField metadataFieldsItem) {
    if (this.metadataFields == null) {
      this.metadataFields = new HashMap<>();
    }
    this.metadataFields.put(key, metadataFieldsItem);
    return this;
  }

   /**
   * Get metadataFields
   * @return metadataFields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, DocumentField> getMetadataFields() {
    return metadataFields;
  }


  @JsonProperty(JSON_PROPERTY_METADATA_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadataFields(Map<String, DocumentField> metadataFields) {
    this.metadataFields = metadataFields;
  }


  public SearchHit nestedIdentity(NestedIdentity nestedIdentity) {
    
    this.nestedIdentity = nestedIdentity;
    return this;
  }

   /**
   * Get nestedIdentity
   * @return nestedIdentity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NESTED_IDENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NestedIdentity getNestedIdentity() {
    return nestedIdentity;
  }


  @JsonProperty(JSON_PROPERTY_NESTED_IDENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNestedIdentity(NestedIdentity nestedIdentity) {
    this.nestedIdentity = nestedIdentity;
  }


  public SearchHit primaryTerm(Long primaryTerm) {
    
    this.primaryTerm = primaryTerm;
    return this;
  }

   /**
   * Get primaryTerm
   * @return primaryTerm
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRIMARY_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPrimaryTerm() {
    return primaryTerm;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY_TERM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimaryTerm(Long primaryTerm) {
    this.primaryTerm = primaryTerm;
  }


  public SearchHit rawSortValues(List<Object> rawSortValues) {
    
    this.rawSortValues = rawSortValues;
    return this;
  }

  public SearchHit addRawSortValuesItem(Object rawSortValuesItem) {
    if (this.rawSortValues == null) {
      this.rawSortValues = new ArrayList<>();
    }
    this.rawSortValues.add(rawSortValuesItem);
    return this;
  }

   /**
   * Get rawSortValues
   * @return rawSortValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RAW_SORT_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getRawSortValues() {
    return rawSortValues;
  }


  @JsonProperty(JSON_PROPERTY_RAW_SORT_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRawSortValues(List<Object> rawSortValues) {
    this.rawSortValues = rawSortValues;
  }


  public SearchHit score(Float score) {
    
    this.score = score;
    return this;
  }

   /**
   * Get score
   * @return score
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getScore() {
    return score;
  }


  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScore(Float score) {
    this.score = score;
  }


  public SearchHit seqNo(Long seqNo) {
    
    this.seqNo = seqNo;
    return this;
  }

   /**
   * Get seqNo
   * @return seqNo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SEQ_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSeqNo() {
    return seqNo;
  }


  @JsonProperty(JSON_PROPERTY_SEQ_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeqNo(Long seqNo) {
    this.seqNo = seqNo;
  }


  public SearchHit shard(SearchShardTarget shard) {
    
    this.shard = shard;
    return this;
  }

   /**
   * Get shard
   * @return shard
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchShardTarget getShard() {
    return shard;
  }


  @JsonProperty(JSON_PROPERTY_SHARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShard(SearchShardTarget shard) {
    this.shard = shard;
  }


  public SearchHit sortValues(List<Object> sortValues) {
    
    this.sortValues = sortValues;
    return this;
  }

  public SearchHit addSortValuesItem(Object sortValuesItem) {
    if (this.sortValues == null) {
      this.sortValues = new ArrayList<>();
    }
    this.sortValues.add(sortValuesItem);
    return this;
  }

   /**
   * Get sortValues
   * @return sortValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SORT_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getSortValues() {
    return sortValues;
  }


  @JsonProperty(JSON_PROPERTY_SORT_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortValues(List<Object> sortValues) {
    this.sortValues = sortValues;
  }


  public SearchHit sourceAsMap(Map<String, Object> sourceAsMap) {
    
    this.sourceAsMap = sourceAsMap;
    return this;
  }

  public SearchHit putSourceAsMapItem(String key, Object sourceAsMapItem) {
    if (this.sourceAsMap == null) {
      this.sourceAsMap = new HashMap<>();
    }
    this.sourceAsMap.put(key, sourceAsMapItem);
    return this;
  }

   /**
   * Get sourceAsMap
   * @return sourceAsMap
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_AS_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getSourceAsMap() {
    return sourceAsMap;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AS_MAP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAsMap(Map<String, Object> sourceAsMap) {
    this.sourceAsMap = sourceAsMap;
  }


  public SearchHit sourceAsString(String sourceAsString) {
    
    this.sourceAsString = sourceAsString;
    return this;
  }

   /**
   * Get sourceAsString
   * @return sourceAsString
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_AS_STRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAsString() {
    return sourceAsString;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AS_STRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAsString(String sourceAsString) {
    this.sourceAsString = sourceAsString;
  }


  public SearchHit sourceRef(BytesReference sourceRef) {
    
    this.sourceRef = sourceRef;
    return this;
  }

   /**
   * Get sourceRef
   * @return sourceRef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BytesReference getSourceRef() {
    return sourceRef;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceRef(BytesReference sourceRef) {
    this.sourceRef = sourceRef;
  }


  public SearchHit type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public SearchHit version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchHit searchHit = (SearchHit) o;
    return Objects.equals(this.clusterAlias, searchHit.clusterAlias) &&
        Objects.equals(this.documentFields, searchHit.documentFields) &&
        Objects.equals(this.explanation, searchHit.explanation) &&
        Objects.equals(this.fields, searchHit.fields) &&
        Objects.equals(this.fragment, searchHit.fragment) &&
        Objects.equals(this.highlightFields, searchHit.highlightFields) &&
        Objects.equals(this.id, searchHit.id) &&
        Objects.equals(this.index, searchHit.index) &&
        Objects.equals(this.innerHits, searchHit.innerHits) &&
        Objects.equals(this.matchedQueries, searchHit.matchedQueries) &&
        Objects.equals(this.metadataFields, searchHit.metadataFields) &&
        Objects.equals(this.nestedIdentity, searchHit.nestedIdentity) &&
        Objects.equals(this.primaryTerm, searchHit.primaryTerm) &&
        Objects.equals(this.rawSortValues, searchHit.rawSortValues) &&
        Objects.equals(this.score, searchHit.score) &&
        Objects.equals(this.seqNo, searchHit.seqNo) &&
        Objects.equals(this.shard, searchHit.shard) &&
        Objects.equals(this.sortValues, searchHit.sortValues) &&
        Objects.equals(this.sourceAsMap, searchHit.sourceAsMap) &&
        Objects.equals(this.sourceAsString, searchHit.sourceAsString) &&
        Objects.equals(this.sourceRef, searchHit.sourceRef) &&
        Objects.equals(this.type, searchHit.type) &&
        Objects.equals(this.version, searchHit.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clusterAlias, documentFields, explanation, fields, fragment, highlightFields, id, index, innerHits, matchedQueries, metadataFields, nestedIdentity, primaryTerm, rawSortValues, score, seqNo, shard, sortValues, sourceAsMap, sourceAsString, sourceRef, type, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchHit {\n");
    sb.append("    clusterAlias: ").append(toIndentedString(clusterAlias)).append("\n");
    sb.append("    documentFields: ").append(toIndentedString(documentFields)).append("\n");
    sb.append("    explanation: ").append(toIndentedString(explanation)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    highlightFields: ").append(toIndentedString(highlightFields)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    innerHits: ").append(toIndentedString(innerHits)).append("\n");
    sb.append("    matchedQueries: ").append(toIndentedString(matchedQueries)).append("\n");
    sb.append("    metadataFields: ").append(toIndentedString(metadataFields)).append("\n");
    sb.append("    nestedIdentity: ").append(toIndentedString(nestedIdentity)).append("\n");
    sb.append("    primaryTerm: ").append(toIndentedString(primaryTerm)).append("\n");
    sb.append("    rawSortValues: ").append(toIndentedString(rawSortValues)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("    seqNo: ").append(toIndentedString(seqNo)).append("\n");
    sb.append("    shard: ").append(toIndentedString(shard)).append("\n");
    sb.append("    sortValues: ").append(toIndentedString(sortValues)).append("\n");
    sb.append("    sourceAsMap: ").append(toIndentedString(sourceAsMap)).append("\n");
    sb.append("    sourceAsString: ").append(toIndentedString(sourceAsString)).append("\n");
    sb.append("    sourceRef: ").append(toIndentedString(sourceRef)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

