/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.SearchHit;
import org.openmetadata.client.model.SortField;
import org.openmetadata.client.model.TotalHits;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * SearchHits
 */
@JsonPropertyOrder({
  SearchHits.JSON_PROPERTY_COLLAPSE_FIELD,
  SearchHits.JSON_PROPERTY_COLLAPSE_VALUES,
  SearchHits.JSON_PROPERTY_FRAGMENT,
  SearchHits.JSON_PROPERTY_HITS,
  SearchHits.JSON_PROPERTY_MAX_SCORE,
  SearchHits.JSON_PROPERTY_SORT_FIELDS,
  SearchHits.JSON_PROPERTY_TOTAL_HITS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class SearchHits {
  public static final String JSON_PROPERTY_COLLAPSE_FIELD = "collapseField";
  private String collapseField;

  public static final String JSON_PROPERTY_COLLAPSE_VALUES = "collapseValues";
  private List<Object> collapseValues = null;

  public static final String JSON_PROPERTY_FRAGMENT = "fragment";
  private Boolean fragment;

  public static final String JSON_PROPERTY_HITS = "hits";
  private List<SearchHit> hits = null;

  public static final String JSON_PROPERTY_MAX_SCORE = "maxScore";
  private Float maxScore;

  public static final String JSON_PROPERTY_SORT_FIELDS = "sortFields";
  private List<SortField> sortFields = null;

  public static final String JSON_PROPERTY_TOTAL_HITS = "totalHits";
  private TotalHits totalHits;

  public SearchHits() { 
  }

  public SearchHits collapseField(String collapseField) {
    
    this.collapseField = collapseField;
    return this;
  }

   /**
   * Get collapseField
   * @return collapseField
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLAPSE_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCollapseField() {
    return collapseField;
  }


  @JsonProperty(JSON_PROPERTY_COLLAPSE_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCollapseField(String collapseField) {
    this.collapseField = collapseField;
  }


  public SearchHits collapseValues(List<Object> collapseValues) {
    
    this.collapseValues = collapseValues;
    return this;
  }

  public SearchHits addCollapseValuesItem(Object collapseValuesItem) {
    if (this.collapseValues == null) {
      this.collapseValues = new ArrayList<>();
    }
    this.collapseValues.add(collapseValuesItem);
    return this;
  }

   /**
   * Get collapseValues
   * @return collapseValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLAPSE_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCollapseValues() {
    return collapseValues;
  }


  @JsonProperty(JSON_PROPERTY_COLLAPSE_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCollapseValues(List<Object> collapseValues) {
    this.collapseValues = collapseValues;
  }


  public SearchHits fragment(Boolean fragment) {
    
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFragment() {
    return fragment;
  }


  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }


  public SearchHits hits(List<SearchHit> hits) {
    
    this.hits = hits;
    return this;
  }

  public SearchHits addHitsItem(SearchHit hitsItem) {
    if (this.hits == null) {
      this.hits = new ArrayList<>();
    }
    this.hits.add(hitsItem);
    return this;
  }

   /**
   * Get hits
   * @return hits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SearchHit> getHits() {
    return hits;
  }


  @JsonProperty(JSON_PROPERTY_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHits(List<SearchHit> hits) {
    this.hits = hits;
  }


  public SearchHits maxScore(Float maxScore) {
    
    this.maxScore = maxScore;
    return this;
  }

   /**
   * Get maxScore
   * @return maxScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMaxScore() {
    return maxScore;
  }


  @JsonProperty(JSON_PROPERTY_MAX_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxScore(Float maxScore) {
    this.maxScore = maxScore;
  }


  public SearchHits sortFields(List<SortField> sortFields) {
    
    this.sortFields = sortFields;
    return this;
  }

  public SearchHits addSortFieldsItem(SortField sortFieldsItem) {
    if (this.sortFields == null) {
      this.sortFields = new ArrayList<>();
    }
    this.sortFields.add(sortFieldsItem);
    return this;
  }

   /**
   * Get sortFields
   * @return sortFields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SORT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SortField> getSortFields() {
    return sortFields;
  }


  @JsonProperty(JSON_PROPERTY_SORT_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortFields(List<SortField> sortFields) {
    this.sortFields = sortFields;
  }


  public SearchHits totalHits(TotalHits totalHits) {
    
    this.totalHits = totalHits;
    return this;
  }

   /**
   * Get totalHits
   * @return totalHits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TotalHits getTotalHits() {
    return totalHits;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalHits(TotalHits totalHits) {
    this.totalHits = totalHits;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchHits searchHits = (SearchHits) o;
    return Objects.equals(this.collapseField, searchHits.collapseField) &&
        Objects.equals(this.collapseValues, searchHits.collapseValues) &&
        Objects.equals(this.fragment, searchHits.fragment) &&
        Objects.equals(this.hits, searchHits.hits) &&
        Objects.equals(this.maxScore, searchHits.maxScore) &&
        Objects.equals(this.sortFields, searchHits.sortFields) &&
        Objects.equals(this.totalHits, searchHits.totalHits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(collapseField, collapseValues, fragment, hits, maxScore, sortFields, totalHits);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchHits {\n");
    sb.append("    collapseField: ").append(toIndentedString(collapseField)).append("\n");
    sb.append("    collapseValues: ").append(toIndentedString(collapseValues)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    hits: ").append(toIndentedString(hits)).append("\n");
    sb.append("    maxScore: ").append(toIndentedString(maxScore)).append("\n");
    sb.append("    sortFields: ").append(toIndentedString(sortFields)).append("\n");
    sb.append("    totalHits: ").append(toIndentedString(totalHits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

