/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.client.model.Aggregations;
import org.openmetadata.client.model.Clusters;
import org.openmetadata.client.model.SearchHits;
import org.openmetadata.client.model.SearchProfileShardResult;
import org.openmetadata.client.model.SearchResponseSections;
import org.openmetadata.client.model.ShardSearchFailure;
import org.openmetadata.client.model.Suggest;
import org.openmetadata.client.model.TimeValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * SearchResponse
 */
@JsonPropertyOrder({
  SearchResponse.JSON_PROPERTY_AGGREGATIONS,
  SearchResponse.JSON_PROPERTY_CLUSTERS,
  SearchResponse.JSON_PROPERTY_FAILED_SHARDS,
  SearchResponse.JSON_PROPERTY_FRAGMENT,
  SearchResponse.JSON_PROPERTY_HITS,
  SearchResponse.JSON_PROPERTY_INTERNAL_RESPONSE,
  SearchResponse.JSON_PROPERTY_NUM_REDUCE_PHASES,
  SearchResponse.JSON_PROPERTY_PROFILE_RESULTS,
  SearchResponse.JSON_PROPERTY_SCROLL_ID,
  SearchResponse.JSON_PROPERTY_SHARD_FAILURES,
  SearchResponse.JSON_PROPERTY_SKIPPED_SHARDS,
  SearchResponse.JSON_PROPERTY_SUCCESSFUL_SHARDS,
  SearchResponse.JSON_PROPERTY_SUGGEST,
  SearchResponse.JSON_PROPERTY_TERMINATED_EARLY,
  SearchResponse.JSON_PROPERTY_TIMED_OUT,
  SearchResponse.JSON_PROPERTY_TOOK,
  SearchResponse.JSON_PROPERTY_TOTAL_SHARDS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class SearchResponse {
  public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
  private Aggregations aggregations;

  public static final String JSON_PROPERTY_CLUSTERS = "clusters";
  private Clusters clusters;

  public static final String JSON_PROPERTY_FAILED_SHARDS = "failedShards";
  private Integer failedShards;

  public static final String JSON_PROPERTY_FRAGMENT = "fragment";
  private Boolean fragment;

  public static final String JSON_PROPERTY_HITS = "hits";
  private SearchHits hits;

  public static final String JSON_PROPERTY_INTERNAL_RESPONSE = "internalResponse";
  private SearchResponseSections internalResponse;

  public static final String JSON_PROPERTY_NUM_REDUCE_PHASES = "numReducePhases";
  private Integer numReducePhases;

  public static final String JSON_PROPERTY_PROFILE_RESULTS = "profileResults";
  private Map<String, SearchProfileShardResult> profileResults = null;

  public static final String JSON_PROPERTY_SCROLL_ID = "scrollId";
  private String scrollId;

  public static final String JSON_PROPERTY_SHARD_FAILURES = "shardFailures";
  private List<ShardSearchFailure> shardFailures = null;

  public static final String JSON_PROPERTY_SKIPPED_SHARDS = "skippedShards";
  private Integer skippedShards;

  public static final String JSON_PROPERTY_SUCCESSFUL_SHARDS = "successfulShards";
  private Integer successfulShards;

  public static final String JSON_PROPERTY_SUGGEST = "suggest";
  private Suggest suggest;

  public static final String JSON_PROPERTY_TERMINATED_EARLY = "terminatedEarly";
  private Boolean terminatedEarly;

  public static final String JSON_PROPERTY_TIMED_OUT = "timedOut";
  private Boolean timedOut;

  public static final String JSON_PROPERTY_TOOK = "took";
  private TimeValue took;

  public static final String JSON_PROPERTY_TOTAL_SHARDS = "totalShards";
  private Integer totalShards;

  public SearchResponse() { 
  }

  public SearchResponse aggregations(Aggregations aggregations) {
    
    this.aggregations = aggregations;
    return this;
  }

   /**
   * Get aggregations
   * @return aggregations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Aggregations getAggregations() {
    return aggregations;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregations(Aggregations aggregations) {
    this.aggregations = aggregations;
  }


  public SearchResponse clusters(Clusters clusters) {
    
    this.clusters = clusters;
    return this;
  }

   /**
   * Get clusters
   * @return clusters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLUSTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Clusters getClusters() {
    return clusters;
  }


  @JsonProperty(JSON_PROPERTY_CLUSTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusters(Clusters clusters) {
    this.clusters = clusters;
  }


  public SearchResponse failedShards(Integer failedShards) {
    
    this.failedShards = failedShards;
    return this;
  }

   /**
   * Get failedShards
   * @return failedShards
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FAILED_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFailedShards() {
    return failedShards;
  }


  @JsonProperty(JSON_PROPERTY_FAILED_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailedShards(Integer failedShards) {
    this.failedShards = failedShards;
  }


  public SearchResponse fragment(Boolean fragment) {
    
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFragment() {
    return fragment;
  }


  @JsonProperty(JSON_PROPERTY_FRAGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }


  public SearchResponse hits(SearchHits hits) {
    
    this.hits = hits;
    return this;
  }

   /**
   * Get hits
   * @return hits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchHits getHits() {
    return hits;
  }


  @JsonProperty(JSON_PROPERTY_HITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHits(SearchHits hits) {
    this.hits = hits;
  }


  public SearchResponse internalResponse(SearchResponseSections internalResponse) {
    
    this.internalResponse = internalResponse;
    return this;
  }

   /**
   * Get internalResponse
   * @return internalResponse
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchResponseSections getInternalResponse() {
    return internalResponse;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalResponse(SearchResponseSections internalResponse) {
    this.internalResponse = internalResponse;
  }


  public SearchResponse numReducePhases(Integer numReducePhases) {
    
    this.numReducePhases = numReducePhases;
    return this;
  }

   /**
   * Get numReducePhases
   * @return numReducePhases
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NUM_REDUCE_PHASES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumReducePhases() {
    return numReducePhases;
  }


  @JsonProperty(JSON_PROPERTY_NUM_REDUCE_PHASES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumReducePhases(Integer numReducePhases) {
    this.numReducePhases = numReducePhases;
  }


  public SearchResponse profileResults(Map<String, SearchProfileShardResult> profileResults) {
    
    this.profileResults = profileResults;
    return this;
  }

  public SearchResponse putProfileResultsItem(String key, SearchProfileShardResult profileResultsItem) {
    if (this.profileResults == null) {
      this.profileResults = new HashMap<>();
    }
    this.profileResults.put(key, profileResultsItem);
    return this;
  }

   /**
   * Get profileResults
   * @return profileResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, SearchProfileShardResult> getProfileResults() {
    return profileResults;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileResults(Map<String, SearchProfileShardResult> profileResults) {
    this.profileResults = profileResults;
  }


  public SearchResponse scrollId(String scrollId) {
    
    this.scrollId = scrollId;
    return this;
  }

   /**
   * Get scrollId
   * @return scrollId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SCROLL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScrollId() {
    return scrollId;
  }


  @JsonProperty(JSON_PROPERTY_SCROLL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScrollId(String scrollId) {
    this.scrollId = scrollId;
  }


  public SearchResponse shardFailures(List<ShardSearchFailure> shardFailures) {
    
    this.shardFailures = shardFailures;
    return this;
  }

  public SearchResponse addShardFailuresItem(ShardSearchFailure shardFailuresItem) {
    if (this.shardFailures == null) {
      this.shardFailures = new ArrayList<>();
    }
    this.shardFailures.add(shardFailuresItem);
    return this;
  }

   /**
   * Get shardFailures
   * @return shardFailures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHARD_FAILURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ShardSearchFailure> getShardFailures() {
    return shardFailures;
  }


  @JsonProperty(JSON_PROPERTY_SHARD_FAILURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShardFailures(List<ShardSearchFailure> shardFailures) {
    this.shardFailures = shardFailures;
  }


  public SearchResponse skippedShards(Integer skippedShards) {
    
    this.skippedShards = skippedShards;
    return this;
  }

   /**
   * Get skippedShards
   * @return skippedShards
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SKIPPED_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSkippedShards() {
    return skippedShards;
  }


  @JsonProperty(JSON_PROPERTY_SKIPPED_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSkippedShards(Integer skippedShards) {
    this.skippedShards = skippedShards;
  }


  public SearchResponse successfulShards(Integer successfulShards) {
    
    this.successfulShards = successfulShards;
    return this;
  }

   /**
   * Get successfulShards
   * @return successfulShards
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSuccessfulShards() {
    return successfulShards;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESSFUL_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuccessfulShards(Integer successfulShards) {
    this.successfulShards = successfulShards;
  }


  public SearchResponse suggest(Suggest suggest) {
    
    this.suggest = suggest;
    return this;
  }

   /**
   * Get suggest
   * @return suggest
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUGGEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Suggest getSuggest() {
    return suggest;
  }


  @JsonProperty(JSON_PROPERTY_SUGGEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuggest(Suggest suggest) {
    this.suggest = suggest;
  }


  public SearchResponse terminatedEarly(Boolean terminatedEarly) {
    
    this.terminatedEarly = terminatedEarly;
    return this;
  }

   /**
   * Get terminatedEarly
   * @return terminatedEarly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TERMINATED_EARLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTerminatedEarly() {
    return terminatedEarly;
  }


  @JsonProperty(JSON_PROPERTY_TERMINATED_EARLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminatedEarly(Boolean terminatedEarly) {
    this.terminatedEarly = terminatedEarly;
  }


  public SearchResponse timedOut(Boolean timedOut) {
    
    this.timedOut = timedOut;
    return this;
  }

   /**
   * Get timedOut
   * @return timedOut
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMED_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTimedOut() {
    return timedOut;
  }


  @JsonProperty(JSON_PROPERTY_TIMED_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimedOut(Boolean timedOut) {
    this.timedOut = timedOut;
  }


  public SearchResponse took(TimeValue took) {
    
    this.took = took;
    return this;
  }

   /**
   * Get took
   * @return took
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOOK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TimeValue getTook() {
    return took;
  }


  @JsonProperty(JSON_PROPERTY_TOOK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTook(TimeValue took) {
    this.took = took;
  }


  public SearchResponse totalShards(Integer totalShards) {
    
    this.totalShards = totalShards;
    return this;
  }

   /**
   * Get totalShards
   * @return totalShards
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalShards() {
    return totalShards;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SHARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalShards(Integer totalShards) {
    this.totalShards = totalShards;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResponse searchResponse = (SearchResponse) o;
    return Objects.equals(this.aggregations, searchResponse.aggregations) &&
        Objects.equals(this.clusters, searchResponse.clusters) &&
        Objects.equals(this.failedShards, searchResponse.failedShards) &&
        Objects.equals(this.fragment, searchResponse.fragment) &&
        Objects.equals(this.hits, searchResponse.hits) &&
        Objects.equals(this.internalResponse, searchResponse.internalResponse) &&
        Objects.equals(this.numReducePhases, searchResponse.numReducePhases) &&
        Objects.equals(this.profileResults, searchResponse.profileResults) &&
        Objects.equals(this.scrollId, searchResponse.scrollId) &&
        Objects.equals(this.shardFailures, searchResponse.shardFailures) &&
        Objects.equals(this.skippedShards, searchResponse.skippedShards) &&
        Objects.equals(this.successfulShards, searchResponse.successfulShards) &&
        Objects.equals(this.suggest, searchResponse.suggest) &&
        Objects.equals(this.terminatedEarly, searchResponse.terminatedEarly) &&
        Objects.equals(this.timedOut, searchResponse.timedOut) &&
        Objects.equals(this.took, searchResponse.took) &&
        Objects.equals(this.totalShards, searchResponse.totalShards);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aggregations, clusters, failedShards, fragment, hits, internalResponse, numReducePhases, profileResults, scrollId, shardFailures, skippedShards, successfulShards, suggest, terminatedEarly, timedOut, took, totalShards);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResponse {\n");
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    clusters: ").append(toIndentedString(clusters)).append("\n");
    sb.append("    failedShards: ").append(toIndentedString(failedShards)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    hits: ").append(toIndentedString(hits)).append("\n");
    sb.append("    internalResponse: ").append(toIndentedString(internalResponse)).append("\n");
    sb.append("    numReducePhases: ").append(toIndentedString(numReducePhases)).append("\n");
    sb.append("    profileResults: ").append(toIndentedString(profileResults)).append("\n");
    sb.append("    scrollId: ").append(toIndentedString(scrollId)).append("\n");
    sb.append("    shardFailures: ").append(toIndentedString(shardFailures)).append("\n");
    sb.append("    skippedShards: ").append(toIndentedString(skippedShards)).append("\n");
    sb.append("    successfulShards: ").append(toIndentedString(successfulShards)).append("\n");
    sb.append("    suggest: ").append(toIndentedString(suggest)).append("\n");
    sb.append("    terminatedEarly: ").append(toIndentedString(terminatedEarly)).append("\n");
    sb.append("    timedOut: ").append(toIndentedString(timedOut)).append("\n");
    sb.append("    took: ").append(toIndentedString(took)).append("\n");
    sb.append("    totalShards: ").append(toIndentedString(totalShards)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

