/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openmetadata.client.model.ShardId;
import org.openmetadata.client.model.Text;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * SearchShardTarget
 */
@JsonPropertyOrder({
  SearchShardTarget.JSON_PROPERTY_CLUSTER_ALIAS,
  SearchShardTarget.JSON_PROPERTY_FULLY_QUALIFIED_INDEX_NAME,
  SearchShardTarget.JSON_PROPERTY_INDEX,
  SearchShardTarget.JSON_PROPERTY_NODE_ID,
  SearchShardTarget.JSON_PROPERTY_NODE_ID_TEXT,
  SearchShardTarget.JSON_PROPERTY_SHARD_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class SearchShardTarget {
  public static final String JSON_PROPERTY_CLUSTER_ALIAS = "clusterAlias";
  private String clusterAlias;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_INDEX_NAME = "fullyQualifiedIndexName";
  private String fullyQualifiedIndexName;

  public static final String JSON_PROPERTY_INDEX = "index";
  private String index;

  public static final String JSON_PROPERTY_NODE_ID = "nodeId";
  private String nodeId;

  public static final String JSON_PROPERTY_NODE_ID_TEXT = "nodeIdText";
  private Text nodeIdText;

  public static final String JSON_PROPERTY_SHARD_ID = "shardId";
  private ShardId shardId;

  public SearchShardTarget() { 
  }

  public SearchShardTarget clusterAlias(String clusterAlias) {
    
    this.clusterAlias = clusterAlias;
    return this;
  }

   /**
   * Get clusterAlias
   * @return clusterAlias
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLUSTER_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClusterAlias() {
    return clusterAlias;
  }


  @JsonProperty(JSON_PROPERTY_CLUSTER_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusterAlias(String clusterAlias) {
    this.clusterAlias = clusterAlias;
  }


  public SearchShardTarget fullyQualifiedIndexName(String fullyQualifiedIndexName) {
    
    this.fullyQualifiedIndexName = fullyQualifiedIndexName;
    return this;
  }

   /**
   * Get fullyQualifiedIndexName
   * @return fullyQualifiedIndexName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_INDEX_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedIndexName() {
    return fullyQualifiedIndexName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_INDEX_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedIndexName(String fullyQualifiedIndexName) {
    this.fullyQualifiedIndexName = fullyQualifiedIndexName;
  }


  public SearchShardTarget index(String index) {
    
    this.index = index;
    return this;
  }

   /**
   * Get index
   * @return index
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndex() {
    return index;
  }


  @JsonProperty(JSON_PROPERTY_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndex(String index) {
    this.index = index;
  }


  public SearchShardTarget nodeId(String nodeId) {
    
    this.nodeId = nodeId;
    return this;
  }

   /**
   * Get nodeId
   * @return nodeId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNodeId() {
    return nodeId;
  }


  @JsonProperty(JSON_PROPERTY_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodeId(String nodeId) {
    this.nodeId = nodeId;
  }


  public SearchShardTarget nodeIdText(Text nodeIdText) {
    
    this.nodeIdText = nodeIdText;
    return this;
  }

   /**
   * Get nodeIdText
   * @return nodeIdText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NODE_ID_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Text getNodeIdText() {
    return nodeIdText;
  }


  @JsonProperty(JSON_PROPERTY_NODE_ID_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodeIdText(Text nodeIdText) {
    this.nodeIdText = nodeIdText;
  }


  public SearchShardTarget shardId(ShardId shardId) {
    
    this.shardId = shardId;
    return this;
  }

   /**
   * Get shardId
   * @return shardId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShardId getShardId() {
    return shardId;
  }


  @JsonProperty(JSON_PROPERTY_SHARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShardId(ShardId shardId) {
    this.shardId = shardId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchShardTarget searchShardTarget = (SearchShardTarget) o;
    return Objects.equals(this.clusterAlias, searchShardTarget.clusterAlias) &&
        Objects.equals(this.fullyQualifiedIndexName, searchShardTarget.fullyQualifiedIndexName) &&
        Objects.equals(this.index, searchShardTarget.index) &&
        Objects.equals(this.nodeId, searchShardTarget.nodeId) &&
        Objects.equals(this.nodeIdText, searchShardTarget.nodeIdText) &&
        Objects.equals(this.shardId, searchShardTarget.shardId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clusterAlias, fullyQualifiedIndexName, index, nodeId, nodeIdText, shardId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchShardTarget {\n");
    sb.append("    clusterAlias: ").append(toIndentedString(clusterAlias)).append("\n");
    sb.append("    fullyQualifiedIndexName: ").append(toIndentedString(fullyQualifiedIndexName)).append("\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
    sb.append("    nodeIdText: ").append(toIndentedString(nodeIdText)).append("\n");
    sb.append("    shardId: ").append(toIndentedString(shardId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

