/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ShardSearchFailureCauseStackTraceInner
 */
@JsonPropertyOrder({
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_CLASS_LOADER_NAME,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_MODULE_NAME,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_MODULE_VERSION,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_METHOD_NAME,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_FILE_NAME,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_LINE_NUMBER,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_NATIVE_METHOD,
  ShardSearchFailureCauseStackTraceInner.JSON_PROPERTY_CLASS_NAME
})
@JsonTypeName("ShardSearchFailure_cause_stackTrace_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class ShardSearchFailureCauseStackTraceInner {
  public static final String JSON_PROPERTY_CLASS_LOADER_NAME = "classLoaderName";
  private String classLoaderName;

  public static final String JSON_PROPERTY_MODULE_NAME = "moduleName";
  private String moduleName;

  public static final String JSON_PROPERTY_MODULE_VERSION = "moduleVersion";
  private String moduleVersion;

  public static final String JSON_PROPERTY_METHOD_NAME = "methodName";
  private String methodName;

  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName;

  public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
  private Integer lineNumber;

  public static final String JSON_PROPERTY_NATIVE_METHOD = "nativeMethod";
  private Boolean nativeMethod;

  public static final String JSON_PROPERTY_CLASS_NAME = "className";
  private String className;

  public ShardSearchFailureCauseStackTraceInner() { 
  }

  public ShardSearchFailureCauseStackTraceInner classLoaderName(String classLoaderName) {
    
    this.classLoaderName = classLoaderName;
    return this;
  }

   /**
   * Get classLoaderName
   * @return classLoaderName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLASS_LOADER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClassLoaderName() {
    return classLoaderName;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_LOADER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassLoaderName(String classLoaderName) {
    this.classLoaderName = classLoaderName;
  }


  public ShardSearchFailureCauseStackTraceInner moduleName(String moduleName) {
    
    this.moduleName = moduleName;
    return this;
  }

   /**
   * Get moduleName
   * @return moduleName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MODULE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getModuleName() {
    return moduleName;
  }


  @JsonProperty(JSON_PROPERTY_MODULE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModuleName(String moduleName) {
    this.moduleName = moduleName;
  }


  public ShardSearchFailureCauseStackTraceInner moduleVersion(String moduleVersion) {
    
    this.moduleVersion = moduleVersion;
    return this;
  }

   /**
   * Get moduleVersion
   * @return moduleVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MODULE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getModuleVersion() {
    return moduleVersion;
  }


  @JsonProperty(JSON_PROPERTY_MODULE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModuleVersion(String moduleVersion) {
    this.moduleVersion = moduleVersion;
  }


  public ShardSearchFailureCauseStackTraceInner methodName(String methodName) {
    
    this.methodName = methodName;
    return this;
  }

   /**
   * Get methodName
   * @return methodName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METHOD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMethodName() {
    return methodName;
  }


  @JsonProperty(JSON_PROPERTY_METHOD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }


  public ShardSearchFailureCauseStackTraceInner fileName(String fileName) {
    
    this.fileName = fileName;
    return this;
  }

   /**
   * Get fileName
   * @return fileName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  public ShardSearchFailureCauseStackTraceInner lineNumber(Integer lineNumber) {
    
    this.lineNumber = lineNumber;
    return this;
  }

   /**
   * Get lineNumber
   * @return lineNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLineNumber() {
    return lineNumber;
  }


  @JsonProperty(JSON_PROPERTY_LINE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
  }


  public ShardSearchFailureCauseStackTraceInner nativeMethod(Boolean nativeMethod) {
    
    this.nativeMethod = nativeMethod;
    return this;
  }

   /**
   * Get nativeMethod
   * @return nativeMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NATIVE_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNativeMethod() {
    return nativeMethod;
  }


  @JsonProperty(JSON_PROPERTY_NATIVE_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNativeMethod(Boolean nativeMethod) {
    this.nativeMethod = nativeMethod;
  }


  public ShardSearchFailureCauseStackTraceInner className(String className) {
    
    this.className = className;
    return this;
  }

   /**
   * Get className
   * @return className
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClassName() {
    return className;
  }


  @JsonProperty(JSON_PROPERTY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassName(String className) {
    this.className = className;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShardSearchFailureCauseStackTraceInner shardSearchFailureCauseStackTraceInner = (ShardSearchFailureCauseStackTraceInner) o;
    return Objects.equals(this.classLoaderName, shardSearchFailureCauseStackTraceInner.classLoaderName) &&
        Objects.equals(this.moduleName, shardSearchFailureCauseStackTraceInner.moduleName) &&
        Objects.equals(this.moduleVersion, shardSearchFailureCauseStackTraceInner.moduleVersion) &&
        Objects.equals(this.methodName, shardSearchFailureCauseStackTraceInner.methodName) &&
        Objects.equals(this.fileName, shardSearchFailureCauseStackTraceInner.fileName) &&
        Objects.equals(this.lineNumber, shardSearchFailureCauseStackTraceInner.lineNumber) &&
        Objects.equals(this.nativeMethod, shardSearchFailureCauseStackTraceInner.nativeMethod) &&
        Objects.equals(this.className, shardSearchFailureCauseStackTraceInner.className);
  }

  @Override
  public int hashCode() {
    return Objects.hash(classLoaderName, moduleName, moduleVersion, methodName, fileName, lineNumber, nativeMethod, className);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShardSearchFailureCauseStackTraceInner {\n");
    sb.append("    classLoaderName: ").append(toIndentedString(classLoaderName)).append("\n");
    sb.append("    moduleName: ").append(toIndentedString(moduleName)).append("\n");
    sb.append("    moduleVersion: ").append(toIndentedString(moduleVersion)).append("\n");
    sb.append("    methodName: ").append(toIndentedString(methodName)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    lineNumber: ").append(toIndentedString(lineNumber)).append("\n");
    sb.append("    nativeMethod: ").append(toIndentedString(nativeMethod)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

