/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openmetadata.client.model.IndexSorter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * SortField
 */
@JsonPropertyOrder({
  SortField.JSON_PROPERTY_BYTES_COMPARATOR,
  SortField.JSON_PROPERTY_CAN_USE_POINTS,
  SortField.JSON_PROPERTY_COMPARATOR_SOURCE,
  SortField.JSON_PROPERTY_FIELD,
  SortField.JSON_PROPERTY_INDEX_SORTER,
  SortField.JSON_PROPERTY_MISSING_VALUE,
  SortField.JSON_PROPERTY_REVERSE,
  SortField.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class SortField {
  public static final String JSON_PROPERTY_BYTES_COMPARATOR = "bytesComparator";
  private Object bytesComparator;

  public static final String JSON_PROPERTY_CAN_USE_POINTS = "canUsePoints";
  private Boolean canUsePoints;

  public static final String JSON_PROPERTY_COMPARATOR_SOURCE = "comparatorSource";
  private Object comparatorSource;

  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  public static final String JSON_PROPERTY_INDEX_SORTER = "indexSorter";
  private IndexSorter indexSorter;

  public static final String JSON_PROPERTY_MISSING_VALUE = "missingValue";
  private Object missingValue;

  public static final String JSON_PROPERTY_REVERSE = "reverse";
  private Boolean reverse;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    SCORE("SCORE"),
    
    DOC("DOC"),
    
    STRING("STRING"),
    
    INT("INT"),
    
    FLOAT("FLOAT"),
    
    LONG("LONG"),
    
    DOUBLE("DOUBLE"),
    
    CUSTOM("CUSTOM"),
    
    STRING_VAL("STRING_VAL"),
    
    REWRITEABLE("REWRITEABLE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public SortField() { 
  }

  public SortField bytesComparator(Object bytesComparator) {
    
    this.bytesComparator = bytesComparator;
    return this;
  }

   /**
   * Get bytesComparator
   * @return bytesComparator
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BYTES_COMPARATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getBytesComparator() {
    return bytesComparator;
  }


  @JsonProperty(JSON_PROPERTY_BYTES_COMPARATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBytesComparator(Object bytesComparator) {
    this.bytesComparator = bytesComparator;
  }


  public SortField canUsePoints(Boolean canUsePoints) {
    
    this.canUsePoints = canUsePoints;
    return this;
  }

   /**
   * Get canUsePoints
   * @return canUsePoints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CAN_USE_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCanUsePoints() {
    return canUsePoints;
  }


  @JsonProperty(JSON_PROPERTY_CAN_USE_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanUsePoints(Boolean canUsePoints) {
    this.canUsePoints = canUsePoints;
  }


  public SortField comparatorSource(Object comparatorSource) {
    
    this.comparatorSource = comparatorSource;
    return this;
  }

   /**
   * Get comparatorSource
   * @return comparatorSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPARATOR_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getComparatorSource() {
    return comparatorSource;
  }


  @JsonProperty(JSON_PROPERTY_COMPARATOR_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComparatorSource(Object comparatorSource) {
    this.comparatorSource = comparatorSource;
  }


  public SortField field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Get field
   * @return field
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(String field) {
    this.field = field;
  }


  public SortField indexSorter(IndexSorter indexSorter) {
    
    this.indexSorter = indexSorter;
    return this;
  }

   /**
   * Get indexSorter
   * @return indexSorter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDEX_SORTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IndexSorter getIndexSorter() {
    return indexSorter;
  }


  @JsonProperty(JSON_PROPERTY_INDEX_SORTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndexSorter(IndexSorter indexSorter) {
    this.indexSorter = indexSorter;
  }


  public SortField missingValue(Object missingValue) {
    
    this.missingValue = missingValue;
    return this;
  }

   /**
   * Get missingValue
   * @return missingValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MISSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMissingValue() {
    return missingValue;
  }


  @JsonProperty(JSON_PROPERTY_MISSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMissingValue(Object missingValue) {
    this.missingValue = missingValue;
  }


  public SortField reverse(Boolean reverse) {
    
    this.reverse = reverse;
    return this;
  }

   /**
   * Get reverse
   * @return reverse
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVERSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReverse() {
    return reverse;
  }


  @JsonProperty(JSON_PROPERTY_REVERSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReverse(Boolean reverse) {
    this.reverse = reverse;
  }


  public SortField type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SortField sortField = (SortField) o;
    return Objects.equals(this.bytesComparator, sortField.bytesComparator) &&
        Objects.equals(this.canUsePoints, sortField.canUsePoints) &&
        Objects.equals(this.comparatorSource, sortField.comparatorSource) &&
        Objects.equals(this.field, sortField.field) &&
        Objects.equals(this.indexSorter, sortField.indexSorter) &&
        Objects.equals(this.missingValue, sortField.missingValue) &&
        Objects.equals(this.reverse, sortField.reverse) &&
        Objects.equals(this.type, sortField.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bytesComparator, canUsePoints, comparatorSource, field, indexSorter, missingValue, reverse, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SortField {\n");
    sb.append("    bytesComparator: ").append(toIndentedString(bytesComparator)).append("\n");
    sb.append("    canUsePoints: ").append(toIndentedString(canUsePoints)).append("\n");
    sb.append("    comparatorSource: ").append(toIndentedString(comparatorSource)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    indexSorter: ").append(toIndentedString(indexSorter)).append("\n");
    sb.append("    missingValue: ").append(toIndentedString(missingValue)).append("\n");
    sb.append("    reverse: ").append(toIndentedString(reverse)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

