/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TableConstraint;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TablePartition;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Table
 */
@JsonPropertyOrder({
  Table.JSON_PROPERTY_CHANGE_DESCRIPTION,
  Table.JSON_PROPERTY_CHILDREN,
  Table.JSON_PROPERTY_COLUMNS,
  Table.JSON_PROPERTY_DATA_MODEL,
  Table.JSON_PROPERTY_DATA_PRODUCTS,
  Table.JSON_PROPERTY_DATABASE,
  Table.JSON_PROPERTY_DATABASE_SCHEMA,
  Table.JSON_PROPERTY_DELETED,
  Table.JSON_PROPERTY_DESCRIPTION,
  Table.JSON_PROPERTY_DISPLAY_NAME,
  Table.JSON_PROPERTY_DOMAIN,
  Table.JSON_PROPERTY_EXPERTS,
  Table.JSON_PROPERTY_EXTENSION,
  Table.JSON_PROPERTY_FILE_FORMAT,
  Table.JSON_PROPERTY_FOLLOWERS,
  Table.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  Table.JSON_PROPERTY_HREF,
  Table.JSON_PROPERTY_ID,
  Table.JSON_PROPERTY_JOINS,
  Table.JSON_PROPERTY_LIFE_CYCLE,
  Table.JSON_PROPERTY_LOCATION,
  Table.JSON_PROPERTY_NAME,
  Table.JSON_PROPERTY_OWNER,
  Table.JSON_PROPERTY_PROFILE,
  Table.JSON_PROPERTY_PROVIDER,
  Table.JSON_PROPERTY_RETENTION_PERIOD,
  Table.JSON_PROPERTY_REVIEWERS,
  Table.JSON_PROPERTY_SAMPLE_DATA,
  Table.JSON_PROPERTY_SERVICE,
  Table.JSON_PROPERTY_SERVICE_TYPE,
  Table.JSON_PROPERTY_SOURCE_URL,
  Table.JSON_PROPERTY_STYLE,
  Table.JSON_PROPERTY_TABLE_CONSTRAINTS,
  Table.JSON_PROPERTY_TABLE_PARTITION,
  Table.JSON_PROPERTY_TABLE_PROFILER_CONFIG,
  Table.JSON_PROPERTY_TABLE_TYPE,
  Table.JSON_PROPERTY_TAGS,
  Table.JSON_PROPERTY_TEST_SUITE,
  Table.JSON_PROPERTY_UPDATED_AT,
  Table.JSON_PROPERTY_UPDATED_BY,
  Table.JSON_PROPERTY_USAGE_SUMMARY,
  Table.JSON_PROPERTY_VERSION,
  Table.JSON_PROPERTY_VIEW_DEFINITION,
  Table.JSON_PROPERTY_VOTES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class Table {
  public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
  private ChangeDescription changeDescription;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<EntityReference> children = null;

  public static final String JSON_PROPERTY_COLUMNS = "columns";
  private List<Column> columns = new ArrayList<>();

  public static final String JSON_PROPERTY_DATA_MODEL = "dataModel";
  private DataModel dataModel;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<EntityReference> dataProducts = null;

  public static final String JSON_PROPERTY_DATABASE = "database";
  private EntityReference database;

  public static final String JSON_PROPERTY_DATABASE_SCHEMA = "databaseSchema";
  private EntityReference databaseSchema;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private EntityReference domain;

  public static final String JSON_PROPERTY_EXPERTS = "experts";
  private List<EntityReference> experts = null;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  /**
   * Gets or Sets fileFormat
   */
  public enum FileFormatEnum {
    CSV("csv"),
    
    TSV("tsv"),
    
    AVRO("avro"),
    
    PARQUET("parquet"),
    
    JSON("json"),
    
    JSON_GZ("json.gz"),
    
    JSON_ZIP("json.zip");

    private String value;

    FileFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FileFormatEnum fromValue(String value) {
      for (FileFormatEnum b : FileFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
  private FileFormatEnum fileFormat;

  public static final String JSON_PROPERTY_FOLLOWERS = "followers";
  private List<EntityReference> followers = null;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_JOINS = "joins";
  private TableJoins joins;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private EntityReference location;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PROFILE = "profile";
  private TableProfile profile;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_RETENTION_PERIOD = "retentionPeriod";
  private String retentionPeriod;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<EntityReference> reviewers = null;

  public static final String JSON_PROPERTY_SAMPLE_DATA = "sampleData";
  private TableData sampleData;

  public static final String JSON_PROPERTY_SERVICE = "service";
  private EntityReference service;

  /**
   * Gets or Sets serviceType
   */
  public enum ServiceTypeEnum {
    BIGQUERY("BigQuery"),
    
    MYSQL("Mysql"),
    
    REDSHIFT("Redshift"),
    
    SNOWFLAKE("Snowflake"),
    
    POSTGRES("Postgres"),
    
    MSSQL("Mssql"),
    
    ORACLE("Oracle"),
    
    ATHENA("Athena"),
    
    HIVE("Hive"),
    
    IMPALA("Impala"),
    
    PRESTO("Presto"),
    
    TRINO("Trino"),
    
    VERTICA("Vertica"),
    
    GLUE("Glue"),
    
    MARIADB("MariaDB"),
    
    DRUID("Druid"),
    
    DB2("Db2"),
    
    CLICKHOUSE("Clickhouse"),
    
    DATABRICKS("Databricks"),
    
    AZURESQL("AzureSQL"),
    
    DYNAMODB("DynamoDB"),
    
    SINGLESTORE("SingleStore"),
    
    SQLITE("SQLite"),
    
    DELTALAKE("DeltaLake"),
    
    SALESFORCE("Salesforce"),
    
    PINOTDB("PinotDB"),
    
    DATALAKE("Datalake"),
    
    DOMODATABASE("DomoDatabase"),
    
    QUERYLOG("QueryLog"),
    
    CUSTOMDATABASE("CustomDatabase"),
    
    DBT("Dbt"),
    
    SAPHANA("SapHana"),
    
    MONGODB("MongoDB"),
    
    COUCHBASE("Couchbase"),
    
    GREENPLUM("Greenplum");

    private String value;

    ServiceTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServiceTypeEnum fromValue(String value) {
      for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
  private ServiceTypeEnum serviceType;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_TABLE_CONSTRAINTS = "tableConstraints";
  private List<TableConstraint> tableConstraints = null;

  public static final String JSON_PROPERTY_TABLE_PARTITION = "tablePartition";
  private TablePartition tablePartition;

  public static final String JSON_PROPERTY_TABLE_PROFILER_CONFIG = "tableProfilerConfig";
  private TableProfilerConfig tableProfilerConfig;

  /**
   * Gets or Sets tableType
   */
  public enum TableTypeEnum {
    REGULAR("Regular"),
    
    EXTERNAL("External"),
    
    VIEW("View"),
    
    SECUREVIEW("SecureView"),
    
    MATERIALIZEDVIEW("MaterializedView"),
    
    ICEBERG("Iceberg"),
    
    LOCAL("Local"),
    
    PARTITIONED("Partitioned"),
    
    FOREIGN("Foreign"),
    
    TRANSIENT("Transient");

    private String value;

    TableTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TableTypeEnum fromValue(String value) {
      for (TableTypeEnum b : TableTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TABLE_TYPE = "tableType";
  private TableTypeEnum tableType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TEST_SUITE = "testSuite";
  private TestSuite testSuite;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
  private UsageDetails usageSummary;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Double version;

  public static final String JSON_PROPERTY_VIEW_DEFINITION = "viewDefinition";
  private String viewDefinition;

  public static final String JSON_PROPERTY_VOTES = "votes";
  private Votes votes;

  public Table() { 
  }

  public Table changeDescription(ChangeDescription changeDescription) {
    
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }


  public Table children(List<EntityReference> children) {
    
    this.children = children;
    return this;
  }

  public Table addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }


  public Table columns(List<Column> columns) {
    
    this.columns = columns;
    return this;
  }

  public Table addColumnsItem(Column columnsItem) {
    this.columns.add(columnsItem);
    return this;
  }

   /**
   * Get columns
   * @return columns
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Column> getColumns() {
    return columns;
  }


  @JsonProperty(JSON_PROPERTY_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setColumns(List<Column> columns) {
    this.columns = columns;
  }


  public Table dataModel(DataModel dataModel) {
    
    this.dataModel = dataModel;
    return this;
  }

   /**
   * Get dataModel
   * @return dataModel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DataModel getDataModel() {
    return dataModel;
  }


  @JsonProperty(JSON_PROPERTY_DATA_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataModel(DataModel dataModel) {
    this.dataModel = dataModel;
  }


  public Table dataProducts(List<EntityReference> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public Table addDataProductsItem(EntityReference dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<EntityReference> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public Table database(EntityReference database) {
    
    this.database = database;
    return this;
  }

   /**
   * Get database
   * @return database
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDatabase() {
    return database;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatabase(EntityReference database) {
    this.database = database;
  }


  public Table databaseSchema(EntityReference databaseSchema) {
    
    this.databaseSchema = databaseSchema;
    return this;
  }

   /**
   * Get databaseSchema
   * @return databaseSchema
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATABASE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDatabaseSchema() {
    return databaseSchema;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatabaseSchema(EntityReference databaseSchema) {
    this.databaseSchema = databaseSchema;
  }


  public Table deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public Table description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Table displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public Table domain(EntityReference domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(EntityReference domain) {
    this.domain = domain;
  }


  public Table experts(List<EntityReference> experts) {
    
    this.experts = experts;
    return this;
  }

  public Table addExpertsItem(EntityReference expertsItem) {
    if (this.experts == null) {
      this.experts = new ArrayList<>();
    }
    this.experts.add(expertsItem);
    return this;
  }

   /**
   * Get experts
   * @return experts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getExperts() {
    return experts;
  }


  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperts(List<EntityReference> experts) {
    this.experts = experts;
  }


  public Table extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public Table fileFormat(FileFormatEnum fileFormat) {
    
    this.fileFormat = fileFormat;
    return this;
  }

   /**
   * Get fileFormat
   * @return fileFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FileFormatEnum getFileFormat() {
    return fileFormat;
  }


  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileFormat(FileFormatEnum fileFormat) {
    this.fileFormat = fileFormat;
  }


  public Table followers(List<EntityReference> followers) {
    
    this.followers = followers;
    return this;
  }

  public Table addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollowers() {
    return followers;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }


  public Table fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public Table href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public Table id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public Table joins(TableJoins joins) {
    
    this.joins = joins;
    return this;
  }

   /**
   * Get joins
   * @return joins
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_JOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableJoins getJoins() {
    return joins;
  }


  @JsonProperty(JSON_PROPERTY_JOINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJoins(TableJoins joins) {
    this.joins = joins;
  }


  public Table lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public Table location(EntityReference location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(EntityReference location) {
    this.location = location;
  }


  public Table name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Table owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public Table profile(TableProfile profile) {
    
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableProfile getProfile() {
    return profile;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(TableProfile profile) {
    this.profile = profile;
  }


  public Table provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public Table retentionPeriod(String retentionPeriod) {
    
    this.retentionPeriod = retentionPeriod;
    return this;
  }

   /**
   * Get retentionPeriod
   * @return retentionPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETENTION_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRetentionPeriod() {
    return retentionPeriod;
  }


  @JsonProperty(JSON_PROPERTY_RETENTION_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetentionPeriod(String retentionPeriod) {
    this.retentionPeriod = retentionPeriod;
  }


  public Table reviewers(List<EntityReference> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public Table addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }


  public Table sampleData(TableData sampleData) {
    
    this.sampleData = sampleData;
    return this;
  }

   /**
   * Get sampleData
   * @return sampleData
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SAMPLE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableData getSampleData() {
    return sampleData;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSampleData(TableData sampleData) {
    this.sampleData = sampleData;
  }


  public Table service(EntityReference service) {
    
    this.service = service;
    return this;
  }

   /**
   * Get service
   * @return service
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getService() {
    return service;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setService(EntityReference service) {
    this.service = service;
  }


  public Table serviceType(ServiceTypeEnum serviceType) {
    
    this.serviceType = serviceType;
    return this;
  }

   /**
   * Get serviceType
   * @return serviceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SERVICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServiceTypeEnum getServiceType() {
    return serviceType;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServiceType(ServiceTypeEnum serviceType) {
    this.serviceType = serviceType;
  }


  public Table sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Get sourceUrl
   * @return sourceUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public Table style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public Table tableConstraints(List<TableConstraint> tableConstraints) {
    
    this.tableConstraints = tableConstraints;
    return this;
  }

  public Table addTableConstraintsItem(TableConstraint tableConstraintsItem) {
    if (this.tableConstraints == null) {
      this.tableConstraints = new ArrayList<>();
    }
    this.tableConstraints.add(tableConstraintsItem);
    return this;
  }

   /**
   * Get tableConstraints
   * @return tableConstraints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TableConstraint> getTableConstraints() {
    return tableConstraints;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableConstraints(List<TableConstraint> tableConstraints) {
    this.tableConstraints = tableConstraints;
  }


  public Table tablePartition(TablePartition tablePartition) {
    
    this.tablePartition = tablePartition;
    return this;
  }

   /**
   * Get tablePartition
   * @return tablePartition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_PARTITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TablePartition getTablePartition() {
    return tablePartition;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_PARTITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTablePartition(TablePartition tablePartition) {
    this.tablePartition = tablePartition;
  }


  public Table tableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    
    this.tableProfilerConfig = tableProfilerConfig;
    return this;
  }

   /**
   * Get tableProfilerConfig
   * @return tableProfilerConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_PROFILER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableProfilerConfig getTableProfilerConfig() {
    return tableProfilerConfig;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_PROFILER_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    this.tableProfilerConfig = tableProfilerConfig;
  }


  public Table tableType(TableTypeEnum tableType) {
    
    this.tableType = tableType;
    return this;
  }

   /**
   * Get tableType
   * @return tableType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TABLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TableTypeEnum getTableType() {
    return tableType;
  }


  @JsonProperty(JSON_PROPERTY_TABLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTableType(TableTypeEnum tableType) {
    this.tableType = tableType;
  }


  public Table tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public Table addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public Table testSuite(TestSuite testSuite) {
    
    this.testSuite = testSuite;
    return this;
  }

   /**
   * Get testSuite
   * @return testSuite
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEST_SUITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TestSuite getTestSuite() {
    return testSuite;
  }


  @JsonProperty(JSON_PROPERTY_TEST_SUITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestSuite(TestSuite testSuite) {
    this.testSuite = testSuite;
  }


  public Table updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Table updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  public Table usageSummary(UsageDetails usageSummary) {
    
    this.usageSummary = usageSummary;
    return this;
  }

   /**
   * Get usageSummary
   * @return usageSummary
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USAGE_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UsageDetails getUsageSummary() {
    return usageSummary;
  }


  @JsonProperty(JSON_PROPERTY_USAGE_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsageSummary(UsageDetails usageSummary) {
    this.usageSummary = usageSummary;
  }


  public Table version(Double version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Double version) {
    this.version = version;
  }


  public Table viewDefinition(String viewDefinition) {
    
    this.viewDefinition = viewDefinition;
    return this;
  }

   /**
   * Get viewDefinition
   * @return viewDefinition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VIEW_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getViewDefinition() {
    return viewDefinition;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewDefinition(String viewDefinition) {
    this.viewDefinition = viewDefinition;
  }


  public Table votes(Votes votes) {
    
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Votes getVotes() {
    return votes;
  }


  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVotes(Votes votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Table table = (Table) o;
    return Objects.equals(this.changeDescription, table.changeDescription) &&
        Objects.equals(this.children, table.children) &&
        Objects.equals(this.columns, table.columns) &&
        Objects.equals(this.dataModel, table.dataModel) &&
        Objects.equals(this.dataProducts, table.dataProducts) &&
        Objects.equals(this.database, table.database) &&
        Objects.equals(this.databaseSchema, table.databaseSchema) &&
        Objects.equals(this.deleted, table.deleted) &&
        Objects.equals(this.description, table.description) &&
        Objects.equals(this.displayName, table.displayName) &&
        Objects.equals(this.domain, table.domain) &&
        Objects.equals(this.experts, table.experts) &&
        Objects.equals(this.extension, table.extension) &&
        Objects.equals(this.fileFormat, table.fileFormat) &&
        Objects.equals(this.followers, table.followers) &&
        Objects.equals(this.fullyQualifiedName, table.fullyQualifiedName) &&
        Objects.equals(this.href, table.href) &&
        Objects.equals(this.id, table.id) &&
        Objects.equals(this.joins, table.joins) &&
        Objects.equals(this.lifeCycle, table.lifeCycle) &&
        Objects.equals(this.location, table.location) &&
        Objects.equals(this.name, table.name) &&
        Objects.equals(this.owner, table.owner) &&
        Objects.equals(this.profile, table.profile) &&
        Objects.equals(this.provider, table.provider) &&
        Objects.equals(this.retentionPeriod, table.retentionPeriod) &&
        Objects.equals(this.reviewers, table.reviewers) &&
        Objects.equals(this.sampleData, table.sampleData) &&
        Objects.equals(this.service, table.service) &&
        Objects.equals(this.serviceType, table.serviceType) &&
        Objects.equals(this.sourceUrl, table.sourceUrl) &&
        Objects.equals(this.style, table.style) &&
        Objects.equals(this.tableConstraints, table.tableConstraints) &&
        Objects.equals(this.tablePartition, table.tablePartition) &&
        Objects.equals(this.tableProfilerConfig, table.tableProfilerConfig) &&
        Objects.equals(this.tableType, table.tableType) &&
        Objects.equals(this.tags, table.tags) &&
        Objects.equals(this.testSuite, table.testSuite) &&
        Objects.equals(this.updatedAt, table.updatedAt) &&
        Objects.equals(this.updatedBy, table.updatedBy) &&
        Objects.equals(this.usageSummary, table.usageSummary) &&
        Objects.equals(this.version, table.version) &&
        Objects.equals(this.viewDefinition, table.viewDefinition) &&
        Objects.equals(this.votes, table.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, children, columns, dataModel, dataProducts, database, databaseSchema, deleted, description, displayName, domain, experts, extension, fileFormat, followers, fullyQualifiedName, href, id, joins, lifeCycle, location, name, owner, profile, provider, retentionPeriod, reviewers, sampleData, service, serviceType, sourceUrl, style, tableConstraints, tablePartition, tableProfilerConfig, tableType, tags, testSuite, updatedAt, updatedBy, usageSummary, version, viewDefinition, votes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Table {\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    dataModel: ").append(toIndentedString(dataModel)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    databaseSchema: ").append(toIndentedString(databaseSchema)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    experts: ").append(toIndentedString(experts)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    fileFormat: ").append(toIndentedString(fileFormat)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    joins: ").append(toIndentedString(joins)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    retentionPeriod: ").append(toIndentedString(retentionPeriod)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    sampleData: ").append(toIndentedString(sampleData)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    serviceType: ").append(toIndentedString(serviceType)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    tableConstraints: ").append(toIndentedString(tableConstraints)).append("\n");
    sb.append("    tablePartition: ").append(toIndentedString(tablePartition)).append("\n");
    sb.append("    tableProfilerConfig: ").append(toIndentedString(tableProfilerConfig)).append("\n");
    sb.append("    tableType: ").append(toIndentedString(tableType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    testSuite: ").append(toIndentedString(testSuite)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    usageSummary: ").append(toIndentedString(usageSummary)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    viewDefinition: ").append(toIndentedString(viewDefinition)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

