/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * TableProfile
 */
@JsonPropertyOrder({
  TableProfile.JSON_PROPERTY_COLUMN_COUNT,
  TableProfile.JSON_PROPERTY_CREATE_DATE_TIME,
  TableProfile.JSON_PROPERTY_PROFILE_SAMPLE,
  TableProfile.JSON_PROPERTY_PROFILE_SAMPLE_TYPE,
  TableProfile.JSON_PROPERTY_ROW_COUNT,
  TableProfile.JSON_PROPERTY_SIZE_IN_BYTE,
  TableProfile.JSON_PROPERTY_TIMESTAMP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class TableProfile {
  public static final String JSON_PROPERTY_COLUMN_COUNT = "columnCount";
  private Double columnCount;

  public static final String JSON_PROPERTY_CREATE_DATE_TIME = "createDateTime";
  private OffsetDateTime createDateTime;

  public static final String JSON_PROPERTY_PROFILE_SAMPLE = "profileSample";
  private Double profileSample;

  /**
   * Gets or Sets profileSampleType
   */
  public enum ProfileSampleTypeEnum {
    PERCENTAGE("PERCENTAGE"),
    
    ROWS("ROWS");

    private String value;

    ProfileSampleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProfileSampleTypeEnum fromValue(String value) {
      for (ProfileSampleTypeEnum b : ProfileSampleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROFILE_SAMPLE_TYPE = "profileSampleType";
  private ProfileSampleTypeEnum profileSampleType;

  public static final String JSON_PROPERTY_ROW_COUNT = "rowCount";
  private Double rowCount;

  public static final String JSON_PROPERTY_SIZE_IN_BYTE = "sizeInByte";
  private Double sizeInByte;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private Long timestamp;

  public TableProfile() { 
  }

  public TableProfile columnCount(Double columnCount) {
    
    this.columnCount = columnCount;
    return this;
  }

   /**
   * Get columnCount
   * @return columnCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLUMN_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getColumnCount() {
    return columnCount;
  }


  @JsonProperty(JSON_PROPERTY_COLUMN_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColumnCount(Double columnCount) {
    this.columnCount = columnCount;
  }


  public TableProfile createDateTime(OffsetDateTime createDateTime) {
    
    this.createDateTime = createDateTime;
    return this;
  }

   /**
   * Get createDateTime
   * @return createDateTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATE_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreateDateTime() {
    return createDateTime;
  }


  @JsonProperty(JSON_PROPERTY_CREATE_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreateDateTime(OffsetDateTime createDateTime) {
    this.createDateTime = createDateTime;
  }


  public TableProfile profileSample(Double profileSample) {
    
    this.profileSample = profileSample;
    return this;
  }

   /**
   * Get profileSample
   * @return profileSample
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getProfileSample() {
    return profileSample;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileSample(Double profileSample) {
    this.profileSample = profileSample;
  }


  public TableProfile profileSampleType(ProfileSampleTypeEnum profileSampleType) {
    
    this.profileSampleType = profileSampleType;
    return this;
  }

   /**
   * Get profileSampleType
   * @return profileSampleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProfileSampleTypeEnum getProfileSampleType() {
    return profileSampleType;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileSampleType(ProfileSampleTypeEnum profileSampleType) {
    this.profileSampleType = profileSampleType;
  }


  public TableProfile rowCount(Double rowCount) {
    
    this.rowCount = rowCount;
    return this;
  }

   /**
   * Get rowCount
   * @return rowCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROW_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getRowCount() {
    return rowCount;
  }


  @JsonProperty(JSON_PROPERTY_ROW_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRowCount(Double rowCount) {
    this.rowCount = rowCount;
  }


  public TableProfile sizeInByte(Double sizeInByte) {
    
    this.sizeInByte = sizeInByte;
    return this;
  }

   /**
   * Get sizeInByte
   * @return sizeInByte
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SIZE_IN_BYTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSizeInByte() {
    return sizeInByte;
  }


  @JsonProperty(JSON_PROPERTY_SIZE_IN_BYTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSizeInByte(Double sizeInByte) {
    this.sizeInByte = sizeInByte;
  }


  public TableProfile timestamp(Long timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getTimestamp() {
    return timestamp;
  }


  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TableProfile tableProfile = (TableProfile) o;
    return Objects.equals(this.columnCount, tableProfile.columnCount) &&
        Objects.equals(this.createDateTime, tableProfile.createDateTime) &&
        Objects.equals(this.profileSample, tableProfile.profileSample) &&
        Objects.equals(this.profileSampleType, tableProfile.profileSampleType) &&
        Objects.equals(this.rowCount, tableProfile.rowCount) &&
        Objects.equals(this.sizeInByte, tableProfile.sizeInByte) &&
        Objects.equals(this.timestamp, tableProfile.timestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columnCount, createDateTime, profileSample, profileSampleType, rowCount, sizeInByte, timestamp);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TableProfile {\n");
    sb.append("    columnCount: ").append(toIndentedString(columnCount)).append("\n");
    sb.append("    createDateTime: ").append(toIndentedString(createDateTime)).append("\n");
    sb.append("    profileSample: ").append(toIndentedString(profileSample)).append("\n");
    sb.append("    profileSampleType: ").append(toIndentedString(profileSampleType)).append("\n");
    sb.append("    rowCount: ").append(toIndentedString(rowCount)).append("\n");
    sb.append("    sizeInByte: ").append(toIndentedString(sizeInByte)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

