/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.ColumnProfilerConfig;
import org.openmetadata.client.model.PartitionProfilerConfig;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * TableProfilerConfig
 */
@JsonPropertyOrder({
  TableProfilerConfig.JSON_PROPERTY_EXCLUDE_COLUMNS,
  TableProfilerConfig.JSON_PROPERTY_INCLUDE_COLUMNS,
  TableProfilerConfig.JSON_PROPERTY_PARTITIONING,
  TableProfilerConfig.JSON_PROPERTY_PROFILE_QUERY,
  TableProfilerConfig.JSON_PROPERTY_PROFILE_SAMPLE,
  TableProfilerConfig.JSON_PROPERTY_PROFILE_SAMPLE_TYPE,
  TableProfilerConfig.JSON_PROPERTY_SAMPLE_DATA_COUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class TableProfilerConfig {
  public static final String JSON_PROPERTY_EXCLUDE_COLUMNS = "excludeColumns";
  private List<String> excludeColumns = null;

  public static final String JSON_PROPERTY_INCLUDE_COLUMNS = "includeColumns";
  private List<ColumnProfilerConfig> includeColumns = null;

  public static final String JSON_PROPERTY_PARTITIONING = "partitioning";
  private PartitionProfilerConfig partitioning;

  public static final String JSON_PROPERTY_PROFILE_QUERY = "profileQuery";
  private String profileQuery;

  public static final String JSON_PROPERTY_PROFILE_SAMPLE = "profileSample";
  private Double profileSample;

  /**
   * Gets or Sets profileSampleType
   */
  public enum ProfileSampleTypeEnum {
    PERCENTAGE("PERCENTAGE"),
    
    ROWS("ROWS");

    private String value;

    ProfileSampleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProfileSampleTypeEnum fromValue(String value) {
      for (ProfileSampleTypeEnum b : ProfileSampleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROFILE_SAMPLE_TYPE = "profileSampleType";
  private ProfileSampleTypeEnum profileSampleType;

  public static final String JSON_PROPERTY_SAMPLE_DATA_COUNT = "sampleDataCount";
  private Integer sampleDataCount;

  public TableProfilerConfig() { 
  }

  public TableProfilerConfig excludeColumns(List<String> excludeColumns) {
    
    this.excludeColumns = excludeColumns;
    return this;
  }

  public TableProfilerConfig addExcludeColumnsItem(String excludeColumnsItem) {
    if (this.excludeColumns == null) {
      this.excludeColumns = new ArrayList<>();
    }
    this.excludeColumns.add(excludeColumnsItem);
    return this;
  }

   /**
   * Get excludeColumns
   * @return excludeColumns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXCLUDE_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getExcludeColumns() {
    return excludeColumns;
  }


  @JsonProperty(JSON_PROPERTY_EXCLUDE_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExcludeColumns(List<String> excludeColumns) {
    this.excludeColumns = excludeColumns;
  }


  public TableProfilerConfig includeColumns(List<ColumnProfilerConfig> includeColumns) {
    
    this.includeColumns = includeColumns;
    return this;
  }

  public TableProfilerConfig addIncludeColumnsItem(ColumnProfilerConfig includeColumnsItem) {
    if (this.includeColumns == null) {
      this.includeColumns = new ArrayList<>();
    }
    this.includeColumns.add(includeColumnsItem);
    return this;
  }

   /**
   * Get includeColumns
   * @return includeColumns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDE_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ColumnProfilerConfig> getIncludeColumns() {
    return includeColumns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_COLUMNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeColumns(List<ColumnProfilerConfig> includeColumns) {
    this.includeColumns = includeColumns;
  }


  public TableProfilerConfig partitioning(PartitionProfilerConfig partitioning) {
    
    this.partitioning = partitioning;
    return this;
  }

   /**
   * Get partitioning
   * @return partitioning
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARTITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PartitionProfilerConfig getPartitioning() {
    return partitioning;
  }


  @JsonProperty(JSON_PROPERTY_PARTITIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitioning(PartitionProfilerConfig partitioning) {
    this.partitioning = partitioning;
  }


  public TableProfilerConfig profileQuery(String profileQuery) {
    
    this.profileQuery = profileQuery;
    return this;
  }

   /**
   * Get profileQuery
   * @return profileQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfileQuery() {
    return profileQuery;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileQuery(String profileQuery) {
    this.profileQuery = profileQuery;
  }


  public TableProfilerConfig profileSample(Double profileSample) {
    
    this.profileSample = profileSample;
    return this;
  }

   /**
   * Get profileSample
   * @return profileSample
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getProfileSample() {
    return profileSample;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileSample(Double profileSample) {
    this.profileSample = profileSample;
  }


  public TableProfilerConfig profileSampleType(ProfileSampleTypeEnum profileSampleType) {
    
    this.profileSampleType = profileSampleType;
    return this;
  }

   /**
   * Get profileSampleType
   * @return profileSampleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProfileSampleTypeEnum getProfileSampleType() {
    return profileSampleType;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_SAMPLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileSampleType(ProfileSampleTypeEnum profileSampleType) {
    this.profileSampleType = profileSampleType;
  }


  public TableProfilerConfig sampleDataCount(Integer sampleDataCount) {
    
    this.sampleDataCount = sampleDataCount;
    return this;
  }

   /**
   * Get sampleDataCount
   * @return sampleDataCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SAMPLE_DATA_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSampleDataCount() {
    return sampleDataCount;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLE_DATA_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSampleDataCount(Integer sampleDataCount) {
    this.sampleDataCount = sampleDataCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TableProfilerConfig tableProfilerConfig = (TableProfilerConfig) o;
    return Objects.equals(this.excludeColumns, tableProfilerConfig.excludeColumns) &&
        Objects.equals(this.includeColumns, tableProfilerConfig.includeColumns) &&
        Objects.equals(this.partitioning, tableProfilerConfig.partitioning) &&
        Objects.equals(this.profileQuery, tableProfilerConfig.profileQuery) &&
        Objects.equals(this.profileSample, tableProfilerConfig.profileSample) &&
        Objects.equals(this.profileSampleType, tableProfilerConfig.profileSampleType) &&
        Objects.equals(this.sampleDataCount, tableProfilerConfig.sampleDataCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(excludeColumns, includeColumns, partitioning, profileQuery, profileSample, profileSampleType, sampleDataCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TableProfilerConfig {\n");
    sb.append("    excludeColumns: ").append(toIndentedString(excludeColumns)).append("\n");
    sb.append("    includeColumns: ").append(toIndentedString(includeColumns)).append("\n");
    sb.append("    partitioning: ").append(toIndentedString(partitioning)).append("\n");
    sb.append("    profileQuery: ").append(toIndentedString(profileQuery)).append("\n");
    sb.append("    profileSample: ").append(toIndentedString(profileSample)).append("\n");
    sb.append("    profileSampleType: ").append(toIndentedString(profileSampleType)).append("\n");
    sb.append("    sampleDataCount: ").append(toIndentedString(sampleDataCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

