/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestCaseParameterValue;
import org.openmetadata.client.model.TestCaseResult;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.Votes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * TestCase
 */
@JsonPropertyOrder({
  TestCase.JSON_PROPERTY_CHANGE_DESCRIPTION,
  TestCase.JSON_PROPERTY_CHILDREN,
  TestCase.JSON_PROPERTY_DATA_PRODUCTS,
  TestCase.JSON_PROPERTY_DELETED,
  TestCase.JSON_PROPERTY_DESCRIPTION,
  TestCase.JSON_PROPERTY_DISPLAY_NAME,
  TestCase.JSON_PROPERTY_DOMAIN,
  TestCase.JSON_PROPERTY_ENTITY_F_Q_N,
  TestCase.JSON_PROPERTY_ENTITY_LINK,
  TestCase.JSON_PROPERTY_EXPERTS,
  TestCase.JSON_PROPERTY_EXTENSION,
  TestCase.JSON_PROPERTY_FOLLOWERS,
  TestCase.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  TestCase.JSON_PROPERTY_HREF,
  TestCase.JSON_PROPERTY_ID,
  TestCase.JSON_PROPERTY_LIFE_CYCLE,
  TestCase.JSON_PROPERTY_NAME,
  TestCase.JSON_PROPERTY_OWNER,
  TestCase.JSON_PROPERTY_PARAMETER_VALUES,
  TestCase.JSON_PROPERTY_PROVIDER,
  TestCase.JSON_PROPERTY_REVIEWERS,
  TestCase.JSON_PROPERTY_STYLE,
  TestCase.JSON_PROPERTY_TAGS,
  TestCase.JSON_PROPERTY_TEST_CASE_RESULT,
  TestCase.JSON_PROPERTY_TEST_DEFINITION,
  TestCase.JSON_PROPERTY_TEST_SUITE,
  TestCase.JSON_PROPERTY_TEST_SUITES,
  TestCase.JSON_PROPERTY_UPDATED_AT,
  TestCase.JSON_PROPERTY_UPDATED_BY,
  TestCase.JSON_PROPERTY_VERSION,
  TestCase.JSON_PROPERTY_VOTES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class TestCase {
  public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
  private ChangeDescription changeDescription;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<EntityReference> children = null;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<EntityReference> dataProducts = null;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private EntityReference domain;

  public static final String JSON_PROPERTY_ENTITY_F_Q_N = "entityFQN";
  private String entityFQN;

  public static final String JSON_PROPERTY_ENTITY_LINK = "entityLink";
  private String entityLink;

  public static final String JSON_PROPERTY_EXPERTS = "experts";
  private List<EntityReference> experts = null;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_FOLLOWERS = "followers";
  private List<EntityReference> followers = null;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_PARAMETER_VALUES = "parameterValues";
  private List<TestCaseParameterValue> parameterValues = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<EntityReference> reviewers = null;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TEST_CASE_RESULT = "testCaseResult";
  private TestCaseResult testCaseResult;

  public static final String JSON_PROPERTY_TEST_DEFINITION = "testDefinition";
  private EntityReference testDefinition;

  public static final String JSON_PROPERTY_TEST_SUITE = "testSuite";
  private EntityReference testSuite;

  public static final String JSON_PROPERTY_TEST_SUITES = "testSuites";
  private List<TestSuite> testSuites = null;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Double version;

  public static final String JSON_PROPERTY_VOTES = "votes";
  private Votes votes;

  public TestCase() { 
  }

  public TestCase changeDescription(ChangeDescription changeDescription) {
    
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }


  public TestCase children(List<EntityReference> children) {
    
    this.children = children;
    return this;
  }

  public TestCase addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }


  public TestCase dataProducts(List<EntityReference> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public TestCase addDataProductsItem(EntityReference dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<EntityReference> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public TestCase deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public TestCase description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public TestCase displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public TestCase domain(EntityReference domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(EntityReference domain) {
    this.domain = domain;
  }


  public TestCase entityFQN(String entityFQN) {
    
    this.entityFQN = entityFQN;
    return this;
  }

   /**
   * Get entityFQN
   * @return entityFQN
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY_F_Q_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEntityFQN() {
    return entityFQN;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_F_Q_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityFQN(String entityFQN) {
    this.entityFQN = entityFQN;
  }


  public TestCase entityLink(String entityLink) {
    
    this.entityLink = entityLink;
    return this;
  }

   /**
   * Get entityLink
   * @return entityLink
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY_LINK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEntityLink() {
    return entityLink;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_LINK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntityLink(String entityLink) {
    this.entityLink = entityLink;
  }


  public TestCase experts(List<EntityReference> experts) {
    
    this.experts = experts;
    return this;
  }

  public TestCase addExpertsItem(EntityReference expertsItem) {
    if (this.experts == null) {
      this.experts = new ArrayList<>();
    }
    this.experts.add(expertsItem);
    return this;
  }

   /**
   * Get experts
   * @return experts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getExperts() {
    return experts;
  }


  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperts(List<EntityReference> experts) {
    this.experts = experts;
  }


  public TestCase extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public TestCase followers(List<EntityReference> followers) {
    
    this.followers = followers;
    return this;
  }

  public TestCase addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollowers() {
    return followers;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }


  public TestCase fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public TestCase href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public TestCase id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(UUID id) {
    this.id = id;
  }


  public TestCase lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public TestCase name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public TestCase owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public TestCase parameterValues(List<TestCaseParameterValue> parameterValues) {
    
    this.parameterValues = parameterValues;
    return this;
  }

  public TestCase addParameterValuesItem(TestCaseParameterValue parameterValuesItem) {
    if (this.parameterValues == null) {
      this.parameterValues = new ArrayList<>();
    }
    this.parameterValues.add(parameterValuesItem);
    return this;
  }

   /**
   * Get parameterValues
   * @return parameterValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARAMETER_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TestCaseParameterValue> getParameterValues() {
    return parameterValues;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameterValues(List<TestCaseParameterValue> parameterValues) {
    this.parameterValues = parameterValues;
  }


  public TestCase provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public TestCase reviewers(List<EntityReference> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public TestCase addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }


  public TestCase style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public TestCase tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public TestCase addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public TestCase testCaseResult(TestCaseResult testCaseResult) {
    
    this.testCaseResult = testCaseResult;
    return this;
  }

   /**
   * Get testCaseResult
   * @return testCaseResult
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEST_CASE_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TestCaseResult getTestCaseResult() {
    return testCaseResult;
  }


  @JsonProperty(JSON_PROPERTY_TEST_CASE_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestCaseResult(TestCaseResult testCaseResult) {
    this.testCaseResult = testCaseResult;
  }


  public TestCase testDefinition(EntityReference testDefinition) {
    
    this.testDefinition = testDefinition;
    return this;
  }

   /**
   * Get testDefinition
   * @return testDefinition
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TEST_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EntityReference getTestDefinition() {
    return testDefinition;
  }


  @JsonProperty(JSON_PROPERTY_TEST_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestDefinition(EntityReference testDefinition) {
    this.testDefinition = testDefinition;
  }


  public TestCase testSuite(EntityReference testSuite) {
    
    this.testSuite = testSuite;
    return this;
  }

   /**
   * Get testSuite
   * @return testSuite
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TEST_SUITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EntityReference getTestSuite() {
    return testSuite;
  }


  @JsonProperty(JSON_PROPERTY_TEST_SUITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestSuite(EntityReference testSuite) {
    this.testSuite = testSuite;
  }


  public TestCase testSuites(List<TestSuite> testSuites) {
    
    this.testSuites = testSuites;
    return this;
  }

  public TestCase addTestSuitesItem(TestSuite testSuitesItem) {
    if (this.testSuites == null) {
      this.testSuites = new ArrayList<>();
    }
    this.testSuites.add(testSuitesItem);
    return this;
  }

   /**
   * Get testSuites
   * @return testSuites
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEST_SUITES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TestSuite> getTestSuites() {
    return testSuites;
  }


  @JsonProperty(JSON_PROPERTY_TEST_SUITES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestSuites(List<TestSuite> testSuites) {
    this.testSuites = testSuites;
  }


  public TestCase updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public TestCase updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  public TestCase version(Double version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Double version) {
    this.version = version;
  }


  public TestCase votes(Votes votes) {
    
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Votes getVotes() {
    return votes;
  }


  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVotes(Votes votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCase testCase = (TestCase) o;
    return Objects.equals(this.changeDescription, testCase.changeDescription) &&
        Objects.equals(this.children, testCase.children) &&
        Objects.equals(this.dataProducts, testCase.dataProducts) &&
        Objects.equals(this.deleted, testCase.deleted) &&
        Objects.equals(this.description, testCase.description) &&
        Objects.equals(this.displayName, testCase.displayName) &&
        Objects.equals(this.domain, testCase.domain) &&
        Objects.equals(this.entityFQN, testCase.entityFQN) &&
        Objects.equals(this.entityLink, testCase.entityLink) &&
        Objects.equals(this.experts, testCase.experts) &&
        Objects.equals(this.extension, testCase.extension) &&
        Objects.equals(this.followers, testCase.followers) &&
        Objects.equals(this.fullyQualifiedName, testCase.fullyQualifiedName) &&
        Objects.equals(this.href, testCase.href) &&
        Objects.equals(this.id, testCase.id) &&
        Objects.equals(this.lifeCycle, testCase.lifeCycle) &&
        Objects.equals(this.name, testCase.name) &&
        Objects.equals(this.owner, testCase.owner) &&
        Objects.equals(this.parameterValues, testCase.parameterValues) &&
        Objects.equals(this.provider, testCase.provider) &&
        Objects.equals(this.reviewers, testCase.reviewers) &&
        Objects.equals(this.style, testCase.style) &&
        Objects.equals(this.tags, testCase.tags) &&
        Objects.equals(this.testCaseResult, testCase.testCaseResult) &&
        Objects.equals(this.testDefinition, testCase.testDefinition) &&
        Objects.equals(this.testSuite, testCase.testSuite) &&
        Objects.equals(this.testSuites, testCase.testSuites) &&
        Objects.equals(this.updatedAt, testCase.updatedAt) &&
        Objects.equals(this.updatedBy, testCase.updatedBy) &&
        Objects.equals(this.version, testCase.version) &&
        Objects.equals(this.votes, testCase.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, children, dataProducts, deleted, description, displayName, domain, entityFQN, entityLink, experts, extension, followers, fullyQualifiedName, href, id, lifeCycle, name, owner, parameterValues, provider, reviewers, style, tags, testCaseResult, testDefinition, testSuite, testSuites, updatedAt, updatedBy, version, votes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCase {\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    entityFQN: ").append(toIndentedString(entityFQN)).append("\n");
    sb.append("    entityLink: ").append(toIndentedString(entityLink)).append("\n");
    sb.append("    experts: ").append(toIndentedString(experts)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    parameterValues: ").append(toIndentedString(parameterValues)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    testCaseResult: ").append(toIndentedString(testCaseResult)).append("\n");
    sb.append("    testDefinition: ").append(toIndentedString(testDefinition)).append("\n");
    sb.append("    testSuite: ").append(toIndentedString(testSuite)).append("\n");
    sb.append("    testSuites: ").append(toIndentedString(testSuites)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

