/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AnnouncementDetails;
import org.openmetadata.client.model.Post;
import org.openmetadata.client.model.Reaction;
import org.openmetadata.client.model.TaskDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Thread
 */
@JsonPropertyOrder({
  Thread.JSON_PROPERTY_ABOUT,
  Thread.JSON_PROPERTY_ADDRESSED_TO,
  Thread.JSON_PROPERTY_ANNOUNCEMENT,
  Thread.JSON_PROPERTY_CREATED_BY,
  Thread.JSON_PROPERTY_ENTITY_ID,
  Thread.JSON_PROPERTY_HREF,
  Thread.JSON_PROPERTY_ID,
  Thread.JSON_PROPERTY_MESSAGE,
  Thread.JSON_PROPERTY_POSTS,
  Thread.JSON_PROPERTY_POSTS_COUNT,
  Thread.JSON_PROPERTY_REACTIONS,
  Thread.JSON_PROPERTY_RESOLVED,
  Thread.JSON_PROPERTY_TASK,
  Thread.JSON_PROPERTY_THREAD_TS,
  Thread.JSON_PROPERTY_TYPE,
  Thread.JSON_PROPERTY_UPDATED_AT,
  Thread.JSON_PROPERTY_UPDATED_BY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class Thread {
  public static final String JSON_PROPERTY_ABOUT = "about";
  private String about;

  public static final String JSON_PROPERTY_ADDRESSED_TO = "addressedTo";
  private String addressedTo;

  public static final String JSON_PROPERTY_ANNOUNCEMENT = "announcement";
  private AnnouncementDetails announcement;

  public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
  private String createdBy;

  public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
  private UUID entityId;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_POSTS = "posts";
  private List<Post> posts = null;

  public static final String JSON_PROPERTY_POSTS_COUNT = "postsCount";
  private Integer postsCount;

  public static final String JSON_PROPERTY_REACTIONS = "reactions";
  private List<Reaction> reactions = null;

  public static final String JSON_PROPERTY_RESOLVED = "resolved";
  private Boolean resolved;

  public static final String JSON_PROPERTY_TASK = "task";
  private TaskDetails task;

  public static final String JSON_PROPERTY_THREAD_TS = "threadTs";
  private Long threadTs;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    CONVERSATION("Conversation"),
    
    TASK("Task"),
    
    ANNOUNCEMENT("Announcement");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public Thread() { 
  }

  public Thread about(String about) {
    
    this.about = about;
    return this;
  }

   /**
   * Get about
   * @return about
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ABOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAbout() {
    return about;
  }


  @JsonProperty(JSON_PROPERTY_ABOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAbout(String about) {
    this.about = about;
  }


  public Thread addressedTo(String addressedTo) {
    
    this.addressedTo = addressedTo;
    return this;
  }

   /**
   * Get addressedTo
   * @return addressedTo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressedTo() {
    return addressedTo;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESSED_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddressedTo(String addressedTo) {
    this.addressedTo = addressedTo;
  }


  public Thread announcement(AnnouncementDetails announcement) {
    
    this.announcement = announcement;
    return this;
  }

   /**
   * Get announcement
   * @return announcement
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AnnouncementDetails getAnnouncement() {
    return announcement;
  }


  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnouncement(AnnouncementDetails announcement) {
    this.announcement = announcement;
  }


  public Thread createdBy(String createdBy) {
    
    this.createdBy = createdBy;
    return this;
  }

   /**
   * Get createdBy
   * @return createdBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedBy() {
    return createdBy;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }


  public Thread entityId(UUID entityId) {
    
    this.entityId = entityId;
    return this;
  }

   /**
   * Get entityId
   * @return entityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getEntityId() {
    return entityId;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityId(UUID entityId) {
    this.entityId = entityId;
  }


  public Thread href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public Thread id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public Thread message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessage(String message) {
    this.message = message;
  }


  public Thread posts(List<Post> posts) {
    
    this.posts = posts;
    return this;
  }

  public Thread addPostsItem(Post postsItem) {
    if (this.posts == null) {
      this.posts = new ArrayList<>();
    }
    this.posts.add(postsItem);
    return this;
  }

   /**
   * Get posts
   * @return posts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Post> getPosts() {
    return posts;
  }


  @JsonProperty(JSON_PROPERTY_POSTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosts(List<Post> posts) {
    this.posts = posts;
  }


  public Thread postsCount(Integer postsCount) {
    
    this.postsCount = postsCount;
    return this;
  }

   /**
   * Get postsCount
   * @return postsCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POSTS_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPostsCount() {
    return postsCount;
  }


  @JsonProperty(JSON_PROPERTY_POSTS_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostsCount(Integer postsCount) {
    this.postsCount = postsCount;
  }


  public Thread reactions(List<Reaction> reactions) {
    
    this.reactions = reactions;
    return this;
  }

  public Thread addReactionsItem(Reaction reactionsItem) {
    if (this.reactions == null) {
      this.reactions = new ArrayList<>();
    }
    this.reactions.add(reactionsItem);
    return this;
  }

   /**
   * Get reactions
   * @return reactions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Reaction> getReactions() {
    return reactions;
  }


  @JsonProperty(JSON_PROPERTY_REACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReactions(List<Reaction> reactions) {
    this.reactions = reactions;
  }


  public Thread resolved(Boolean resolved) {
    
    this.resolved = resolved;
    return this;
  }

   /**
   * Get resolved
   * @return resolved
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESOLVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResolved() {
    return resolved;
  }


  @JsonProperty(JSON_PROPERTY_RESOLVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResolved(Boolean resolved) {
    this.resolved = resolved;
  }


  public Thread task(TaskDetails task) {
    
    this.task = task;
    return this;
  }

   /**
   * Get task
   * @return task
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TASK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TaskDetails getTask() {
    return task;
  }


  @JsonProperty(JSON_PROPERTY_TASK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTask(TaskDetails task) {
    this.task = task;
  }


  public Thread threadTs(Long threadTs) {
    
    this.threadTs = threadTs;
    return this;
  }

   /**
   * Get threadTs
   * @return threadTs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREAD_TS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getThreadTs() {
    return threadTs;
  }


  @JsonProperty(JSON_PROPERTY_THREAD_TS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreadTs(Long threadTs) {
    this.threadTs = threadTs;
  }


  public Thread type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Thread updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Thread updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Thread thread = (Thread) o;
    return Objects.equals(this.about, thread.about) &&
        Objects.equals(this.addressedTo, thread.addressedTo) &&
        Objects.equals(this.announcement, thread.announcement) &&
        Objects.equals(this.createdBy, thread.createdBy) &&
        Objects.equals(this.entityId, thread.entityId) &&
        Objects.equals(this.href, thread.href) &&
        Objects.equals(this.id, thread.id) &&
        Objects.equals(this.message, thread.message) &&
        Objects.equals(this.posts, thread.posts) &&
        Objects.equals(this.postsCount, thread.postsCount) &&
        Objects.equals(this.reactions, thread.reactions) &&
        Objects.equals(this.resolved, thread.resolved) &&
        Objects.equals(this.task, thread.task) &&
        Objects.equals(this.threadTs, thread.threadTs) &&
        Objects.equals(this.type, thread.type) &&
        Objects.equals(this.updatedAt, thread.updatedAt) &&
        Objects.equals(this.updatedBy, thread.updatedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(about, addressedTo, announcement, createdBy, entityId, href, id, message, posts, postsCount, reactions, resolved, task, threadTs, type, updatedAt, updatedBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Thread {\n");
    sb.append("    about: ").append(toIndentedString(about)).append("\n");
    sb.append("    addressedTo: ").append(toIndentedString(addressedTo)).append("\n");
    sb.append("    announcement: ").append(toIndentedString(announcement)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    posts: ").append(toIndentedString(posts)).append("\n");
    sb.append("    postsCount: ").append(toIndentedString(postsCount)).append("\n");
    sb.append("    reactions: ").append(toIndentedString(reactions)).append("\n");
    sb.append("    resolved: ").append(toIndentedString(resolved)).append("\n");
    sb.append("    task: ").append(toIndentedString(task)).append("\n");
    sb.append("    threadTs: ").append(toIndentedString(threadTs)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

