/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * TimeValue
 */
@JsonPropertyOrder({
  TimeValue.JSON_PROPERTY_DAYS,
  TimeValue.JSON_PROPERTY_DAYS_FRAC,
  TimeValue.JSON_PROPERTY_HOURS,
  TimeValue.JSON_PROPERTY_HOURS_FRAC,
  TimeValue.JSON_PROPERTY_MICROS,
  TimeValue.JSON_PROPERTY_MICROS_FRAC,
  TimeValue.JSON_PROPERTY_MILLIS,
  TimeValue.JSON_PROPERTY_MILLIS_FRAC,
  TimeValue.JSON_PROPERTY_MINUTES,
  TimeValue.JSON_PROPERTY_MINUTES_FRAC,
  TimeValue.JSON_PROPERTY_NANOS,
  TimeValue.JSON_PROPERTY_SECONDS,
  TimeValue.JSON_PROPERTY_SECONDS_FRAC,
  TimeValue.JSON_PROPERTY_STRING_REP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class TimeValue {
  public static final String JSON_PROPERTY_DAYS = "days";
  private Long days;

  public static final String JSON_PROPERTY_DAYS_FRAC = "daysFrac";
  private Double daysFrac;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private Long hours;

  public static final String JSON_PROPERTY_HOURS_FRAC = "hoursFrac";
  private Double hoursFrac;

  public static final String JSON_PROPERTY_MICROS = "micros";
  private Long micros;

  public static final String JSON_PROPERTY_MICROS_FRAC = "microsFrac";
  private Double microsFrac;

  public static final String JSON_PROPERTY_MILLIS = "millis";
  private Long millis;

  public static final String JSON_PROPERTY_MILLIS_FRAC = "millisFrac";
  private Double millisFrac;

  public static final String JSON_PROPERTY_MINUTES = "minutes";
  private Long minutes;

  public static final String JSON_PROPERTY_MINUTES_FRAC = "minutesFrac";
  private Double minutesFrac;

  public static final String JSON_PROPERTY_NANOS = "nanos";
  private Long nanos;

  public static final String JSON_PROPERTY_SECONDS = "seconds";
  private Long seconds;

  public static final String JSON_PROPERTY_SECONDS_FRAC = "secondsFrac";
  private Double secondsFrac;

  public static final String JSON_PROPERTY_STRING_REP = "stringRep";
  private String stringRep;

  public TimeValue() { 
  }

  public TimeValue days(Long days) {
    
    this.days = days;
    return this;
  }

   /**
   * Get days
   * @return days
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDays() {
    return days;
  }


  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDays(Long days) {
    this.days = days;
  }


  public TimeValue daysFrac(Double daysFrac) {
    
    this.daysFrac = daysFrac;
    return this;
  }

   /**
   * Get daysFrac
   * @return daysFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAYS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDaysFrac() {
    return daysFrac;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysFrac(Double daysFrac) {
    this.daysFrac = daysFrac;
  }


  public TimeValue hours(Long hours) {
    
    this.hours = hours;
    return this;
  }

   /**
   * Get hours
   * @return hours
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getHours() {
    return hours;
  }


  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHours(Long hours) {
    this.hours = hours;
  }


  public TimeValue hoursFrac(Double hoursFrac) {
    
    this.hoursFrac = hoursFrac;
    return this;
  }

   /**
   * Get hoursFrac
   * @return hoursFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOURS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getHoursFrac() {
    return hoursFrac;
  }


  @JsonProperty(JSON_PROPERTY_HOURS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHoursFrac(Double hoursFrac) {
    this.hoursFrac = hoursFrac;
  }


  public TimeValue micros(Long micros) {
    
    this.micros = micros;
    return this;
  }

   /**
   * Get micros
   * @return micros
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MICROS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMicros() {
    return micros;
  }


  @JsonProperty(JSON_PROPERTY_MICROS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMicros(Long micros) {
    this.micros = micros;
  }


  public TimeValue microsFrac(Double microsFrac) {
    
    this.microsFrac = microsFrac;
    return this;
  }

   /**
   * Get microsFrac
   * @return microsFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MICROS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMicrosFrac() {
    return microsFrac;
  }


  @JsonProperty(JSON_PROPERTY_MICROS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMicrosFrac(Double microsFrac) {
    this.microsFrac = microsFrac;
  }


  public TimeValue millis(Long millis) {
    
    this.millis = millis;
    return this;
  }

   /**
   * Get millis
   * @return millis
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MILLIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMillis() {
    return millis;
  }


  @JsonProperty(JSON_PROPERTY_MILLIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMillis(Long millis) {
    this.millis = millis;
  }


  public TimeValue millisFrac(Double millisFrac) {
    
    this.millisFrac = millisFrac;
    return this;
  }

   /**
   * Get millisFrac
   * @return millisFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MILLIS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMillisFrac() {
    return millisFrac;
  }


  @JsonProperty(JSON_PROPERTY_MILLIS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMillisFrac(Double millisFrac) {
    this.millisFrac = millisFrac;
  }


  public TimeValue minutes(Long minutes) {
    
    this.minutes = minutes;
    return this;
  }

   /**
   * Get minutes
   * @return minutes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMinutes() {
    return minutes;
  }


  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinutes(Long minutes) {
    this.minutes = minutes;
  }


  public TimeValue minutesFrac(Double minutesFrac) {
    
    this.minutesFrac = minutesFrac;
    return this;
  }

   /**
   * Get minutesFrac
   * @return minutesFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MINUTES_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMinutesFrac() {
    return minutesFrac;
  }


  @JsonProperty(JSON_PROPERTY_MINUTES_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinutesFrac(Double minutesFrac) {
    this.minutesFrac = minutesFrac;
  }


  public TimeValue nanos(Long nanos) {
    
    this.nanos = nanos;
    return this;
  }

   /**
   * Get nanos
   * @return nanos
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NANOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNanos() {
    return nanos;
  }


  @JsonProperty(JSON_PROPERTY_NANOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNanos(Long nanos) {
    this.nanos = nanos;
  }


  public TimeValue seconds(Long seconds) {
    
    this.seconds = seconds;
    return this;
  }

   /**
   * Get seconds
   * @return seconds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSeconds() {
    return seconds;
  }


  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeconds(Long seconds) {
    this.seconds = seconds;
  }


  public TimeValue secondsFrac(Double secondsFrac) {
    
    this.secondsFrac = secondsFrac;
    return this;
  }

   /**
   * Get secondsFrac
   * @return secondsFrac
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECONDS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSecondsFrac() {
    return secondsFrac;
  }


  @JsonProperty(JSON_PROPERTY_SECONDS_FRAC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondsFrac(Double secondsFrac) {
    this.secondsFrac = secondsFrac;
  }


  public TimeValue stringRep(String stringRep) {
    
    this.stringRep = stringRep;
    return this;
  }

   /**
   * Get stringRep
   * @return stringRep
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STRING_REP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStringRep() {
    return stringRep;
  }


  @JsonProperty(JSON_PROPERTY_STRING_REP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStringRep(String stringRep) {
    this.stringRep = stringRep;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TimeValue timeValue = (TimeValue) o;
    return Objects.equals(this.days, timeValue.days) &&
        Objects.equals(this.daysFrac, timeValue.daysFrac) &&
        Objects.equals(this.hours, timeValue.hours) &&
        Objects.equals(this.hoursFrac, timeValue.hoursFrac) &&
        Objects.equals(this.micros, timeValue.micros) &&
        Objects.equals(this.microsFrac, timeValue.microsFrac) &&
        Objects.equals(this.millis, timeValue.millis) &&
        Objects.equals(this.millisFrac, timeValue.millisFrac) &&
        Objects.equals(this.minutes, timeValue.minutes) &&
        Objects.equals(this.minutesFrac, timeValue.minutesFrac) &&
        Objects.equals(this.nanos, timeValue.nanos) &&
        Objects.equals(this.seconds, timeValue.seconds) &&
        Objects.equals(this.secondsFrac, timeValue.secondsFrac) &&
        Objects.equals(this.stringRep, timeValue.stringRep);
  }

  @Override
  public int hashCode() {
    return Objects.hash(days, daysFrac, hours, hoursFrac, micros, microsFrac, millis, millisFrac, minutes, minutesFrac, nanos, seconds, secondsFrac, stringRep);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TimeValue {\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    daysFrac: ").append(toIndentedString(daysFrac)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    hoursFrac: ").append(toIndentedString(hoursFrac)).append("\n");
    sb.append("    micros: ").append(toIndentedString(micros)).append("\n");
    sb.append("    microsFrac: ").append(toIndentedString(microsFrac)).append("\n");
    sb.append("    millis: ").append(toIndentedString(millis)).append("\n");
    sb.append("    millisFrac: ").append(toIndentedString(millisFrac)).append("\n");
    sb.append("    minutes: ").append(toIndentedString(minutes)).append("\n");
    sb.append("    minutesFrac: ").append(toIndentedString(minutesFrac)).append("\n");
    sb.append("    nanos: ").append(toIndentedString(nanos)).append("\n");
    sb.append("    seconds: ").append(toIndentedString(seconds)).append("\n");
    sb.append("    secondsFrac: ").append(toIndentedString(secondsFrac)).append("\n");
    sb.append("    stringRep: ").append(toIndentedString(stringRep)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

