/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata service. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.  - Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`.  - Resource URI for an entity instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  **Data Asset APIs** - support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  **Service APIs** - support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes Transactional databases - MySQL, Postgres, MSSQL, Oracle, and Data Warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to Dashboard Services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messagingService` - APIs related to Messaging Services. This includes Apache Kafka, Redpanda, - Kinesis, and others.  **Teams & Users APIs** - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  **Search & Suggest APIs** - support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  **Other APIs** - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities
 *
 * The version of the OpenAPI document: 1.2.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Profile;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.Votes;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * User
 */
@JsonPropertyOrder({
  User.JSON_PROPERTY_AUTHENTICATION_MECHANISM,
  User.JSON_PROPERTY_CHANGE_DESCRIPTION,
  User.JSON_PROPERTY_CHILDREN,
  User.JSON_PROPERTY_DATA_PRODUCTS,
  User.JSON_PROPERTY_DEFAULT_PERSONA,
  User.JSON_PROPERTY_DELETED,
  User.JSON_PROPERTY_DESCRIPTION,
  User.JSON_PROPERTY_DISPLAY_NAME,
  User.JSON_PROPERTY_DOMAIN,
  User.JSON_PROPERTY_EMAIL,
  User.JSON_PROPERTY_EXPERTS,
  User.JSON_PROPERTY_EXTENSION,
  User.JSON_PROPERTY_FOLLOWERS,
  User.JSON_PROPERTY_FOLLOWS,
  User.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  User.JSON_PROPERTY_HREF,
  User.JSON_PROPERTY_ID,
  User.JSON_PROPERTY_INHERITED_ROLES,
  User.JSON_PROPERTY_IS_ADMIN,
  User.JSON_PROPERTY_IS_BOT,
  User.JSON_PROPERTY_IS_EMAIL_VERIFIED,
  User.JSON_PROPERTY_LIFE_CYCLE,
  User.JSON_PROPERTY_NAME,
  User.JSON_PROPERTY_OWNER,
  User.JSON_PROPERTY_OWNS,
  User.JSON_PROPERTY_PERSONAS,
  User.JSON_PROPERTY_PROFILE,
  User.JSON_PROPERTY_PROVIDER,
  User.JSON_PROPERTY_REVIEWERS,
  User.JSON_PROPERTY_ROLES,
  User.JSON_PROPERTY_STYLE,
  User.JSON_PROPERTY_TAGS,
  User.JSON_PROPERTY_TEAMS,
  User.JSON_PROPERTY_TIMEZONE,
  User.JSON_PROPERTY_UPDATED_AT,
  User.JSON_PROPERTY_UPDATED_BY,
  User.JSON_PROPERTY_VERSION,
  User.JSON_PROPERTY_VOTES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-20T11:35:38.398944261Z[Etc/UTC]")
public class User {
  public static final String JSON_PROPERTY_AUTHENTICATION_MECHANISM = "authenticationMechanism";
  private AuthenticationMechanism authenticationMechanism;

  public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
  private ChangeDescription changeDescription;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<EntityReference> children = null;

  public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
  private List<EntityReference> dataProducts = null;

  public static final String JSON_PROPERTY_DEFAULT_PERSONA = "defaultPersona";
  private EntityReference defaultPersona;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DOMAIN = "domain";
  private EntityReference domain;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_EXPERTS = "experts";
  private List<EntityReference> experts = null;

  public static final String JSON_PROPERTY_EXTENSION = "extension";
  private Object extension;

  public static final String JSON_PROPERTY_FOLLOWERS = "followers";
  private List<EntityReference> followers = null;

  public static final String JSON_PROPERTY_FOLLOWS = "follows";
  private List<EntityReference> follows = null;

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName;

  public static final String JSON_PROPERTY_HREF = "href";
  private URI href;

  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_INHERITED_ROLES = "inheritedRoles";
  private List<EntityReference> inheritedRoles = null;

  public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
  private Boolean isAdmin;

  public static final String JSON_PROPERTY_IS_BOT = "isBot";
  private Boolean isBot;

  public static final String JSON_PROPERTY_IS_EMAIL_VERIFIED = "isEmailVerified";
  private Boolean isEmailVerified;

  public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
  private LifeCycle lifeCycle;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private EntityReference owner;

  public static final String JSON_PROPERTY_OWNS = "owns";
  private List<EntityReference> owns = null;

  public static final String JSON_PROPERTY_PERSONAS = "personas";
  private List<EntityReference> personas = null;

  public static final String JSON_PROPERTY_PROFILE = "profile";
  private Profile profile;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
  private List<EntityReference> reviewers = null;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<EntityReference> roles = null;

  public static final String JSON_PROPERTY_STYLE = "style";
  private Style style;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<TagLabel> tags = null;

  public static final String JSON_PROPERTY_TEAMS = "teams";
  private List<EntityReference> teams = null;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private Long updatedAt;

  public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
  private String updatedBy;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Double version;

  public static final String JSON_PROPERTY_VOTES = "votes";
  private Votes votes;

  public User() { 
  }

  public User authenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    
    this.authenticationMechanism = authenticationMechanism;
    return this;
  }

   /**
   * Get authenticationMechanism
   * @return authenticationMechanism
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_MECHANISM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticationMechanism getAuthenticationMechanism() {
    return authenticationMechanism;
  }


  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_MECHANISM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    this.authenticationMechanism = authenticationMechanism;
  }


  public User changeDescription(ChangeDescription changeDescription) {
    
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }


  public User children(List<EntityReference> children) {
    
    this.children = children;
    return this;
  }

  public User addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }


  public User dataProducts(List<EntityReference> dataProducts) {
    
    this.dataProducts = dataProducts;
    return this;
  }

  public User addDataProductsItem(EntityReference dataProductsItem) {
    if (this.dataProducts == null) {
      this.dataProducts = new ArrayList<>();
    }
    this.dataProducts.add(dataProductsItem);
    return this;
  }

   /**
   * Get dataProducts
   * @return dataProducts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getDataProducts() {
    return dataProducts;
  }


  @JsonProperty(JSON_PROPERTY_DATA_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataProducts(List<EntityReference> dataProducts) {
    this.dataProducts = dataProducts;
  }


  public User defaultPersona(EntityReference defaultPersona) {
    
    this.defaultPersona = defaultPersona;
    return this;
  }

   /**
   * Get defaultPersona
   * @return defaultPersona
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEFAULT_PERSONA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDefaultPersona() {
    return defaultPersona;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_PERSONA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultPersona(EntityReference defaultPersona) {
    this.defaultPersona = defaultPersona;
  }


  public User deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public User description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public User displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public User domain(EntityReference domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getDomain() {
    return domain;
  }


  @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(EntityReference domain) {
    this.domain = domain;
  }


  public User email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public User experts(List<EntityReference> experts) {
    
    this.experts = experts;
    return this;
  }

  public User addExpertsItem(EntityReference expertsItem) {
    if (this.experts == null) {
      this.experts = new ArrayList<>();
    }
    this.experts.add(expertsItem);
    return this;
  }

   /**
   * Get experts
   * @return experts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getExperts() {
    return experts;
  }


  @JsonProperty(JSON_PROPERTY_EXPERTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperts(List<EntityReference> experts) {
    this.experts = experts;
  }


  public User extension(Object extension) {
    
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExtension() {
    return extension;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtension(Object extension) {
    this.extension = extension;
  }


  public User followers(List<EntityReference> followers) {
    
    this.followers = followers;
    return this;
  }

  public User addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollowers() {
    return followers;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }


  public User follows(List<EntityReference> follows) {
    
    this.follows = follows;
    return this;
  }

  public User addFollowsItem(EntityReference followsItem) {
    if (this.follows == null) {
      this.follows = new ArrayList<>();
    }
    this.follows.add(followsItem);
    return this;
  }

   /**
   * Get follows
   * @return follows
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FOLLOWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getFollows() {
    return follows;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollows(List<EntityReference> follows) {
    this.follows = follows;
  }


  public User fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public User href(URI href) {
    
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public URI getHref() {
    return href;
  }


  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHref(URI href) {
    this.href = href;
  }


  public User id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public User inheritedRoles(List<EntityReference> inheritedRoles) {
    
    this.inheritedRoles = inheritedRoles;
    return this;
  }

  public User addInheritedRolesItem(EntityReference inheritedRolesItem) {
    if (this.inheritedRoles == null) {
      this.inheritedRoles = new ArrayList<>();
    }
    this.inheritedRoles.add(inheritedRolesItem);
    return this;
  }

   /**
   * Get inheritedRoles
   * @return inheritedRoles
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INHERITED_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getInheritedRoles() {
    return inheritedRoles;
  }


  @JsonProperty(JSON_PROPERTY_INHERITED_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInheritedRoles(List<EntityReference> inheritedRoles) {
    this.inheritedRoles = inheritedRoles;
  }


  public User isAdmin(Boolean isAdmin) {
    
    this.isAdmin = isAdmin;
    return this;
  }

   /**
   * Get isAdmin
   * @return isAdmin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsAdmin() {
    return isAdmin;
  }


  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsAdmin(Boolean isAdmin) {
    this.isAdmin = isAdmin;
  }


  public User isBot(Boolean isBot) {
    
    this.isBot = isBot;
    return this;
  }

   /**
   * Get isBot
   * @return isBot
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBot() {
    return isBot;
  }


  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsBot(Boolean isBot) {
    this.isBot = isBot;
  }


  public User isEmailVerified(Boolean isEmailVerified) {
    
    this.isEmailVerified = isEmailVerified;
    return this;
  }

   /**
   * Get isEmailVerified
   * @return isEmailVerified
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_EMAIL_VERIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsEmailVerified() {
    return isEmailVerified;
  }


  @JsonProperty(JSON_PROPERTY_IS_EMAIL_VERIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsEmailVerified(Boolean isEmailVerified) {
    this.isEmailVerified = isEmailVerified;
  }


  public User lifeCycle(LifeCycle lifeCycle) {
    
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Get lifeCycle
   * @return lifeCycle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifeCycle getLifeCycle() {
    return lifeCycle;
  }


  @JsonProperty(JSON_PROPERTY_LIFE_CYCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifeCycle(LifeCycle lifeCycle) {
    this.lifeCycle = lifeCycle;
  }


  public User name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public User owner(EntityReference owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityReference getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }


  public User owns(List<EntityReference> owns) {
    
    this.owns = owns;
    return this;
  }

  public User addOwnsItem(EntityReference ownsItem) {
    if (this.owns == null) {
      this.owns = new ArrayList<>();
    }
    this.owns.add(ownsItem);
    return this;
  }

   /**
   * Get owns
   * @return owns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getOwns() {
    return owns;
  }


  @JsonProperty(JSON_PROPERTY_OWNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwns(List<EntityReference> owns) {
    this.owns = owns;
  }


  public User personas(List<EntityReference> personas) {
    
    this.personas = personas;
    return this;
  }

  public User addPersonasItem(EntityReference personasItem) {
    if (this.personas == null) {
      this.personas = new ArrayList<>();
    }
    this.personas.add(personasItem);
    return this;
  }

   /**
   * Get personas
   * @return personas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERSONAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getPersonas() {
    return personas;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonas(List<EntityReference> personas) {
    this.personas = personas;
  }


  public User profile(Profile profile) {
    
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Profile getProfile() {
    return profile;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(Profile profile) {
    this.profile = profile;
  }


  public User provider(ProviderEnum provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProviderEnum getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  public User reviewers(List<EntityReference> reviewers) {
    
    this.reviewers = reviewers;
    return this;
  }

  public User addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getReviewers() {
    return reviewers;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }


  public User roles(List<EntityReference> roles) {
    
    this.roles = roles;
    return this;
  }

  public User addRolesItem(EntityReference rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * Get roles
   * @return roles
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getRoles() {
    return roles;
  }


  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<EntityReference> roles) {
    this.roles = roles;
  }


  public User style(Style style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Style getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(Style style) {
    this.style = style;
  }


  public User tags(List<TagLabel> tags) {
    
    this.tags = tags;
    return this;
  }

  public User addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TagLabel> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }


  public User teams(List<EntityReference> teams) {
    
    this.teams = teams;
    return this;
  }

  public User addTeamsItem(EntityReference teamsItem) {
    if (this.teams == null) {
      this.teams = new ArrayList<>();
    }
    this.teams.add(teamsItem);
    return this;
  }

   /**
   * Get teams
   * @return teams
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EntityReference> getTeams() {
    return teams;
  }


  @JsonProperty(JSON_PROPERTY_TEAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTeams(List<EntityReference> teams) {
    this.teams = teams;
  }


  public User timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public User updatedAt(Long updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }


  public User updatedBy(String updatedBy) {
    
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedBy() {
    return updatedBy;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  public User version(Double version) {
    
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Double version) {
    this.version = version;
  }


  public User votes(Votes votes) {
    
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Votes getVotes() {
    return votes;
  }


  @JsonProperty(JSON_PROPERTY_VOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVotes(Votes votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.authenticationMechanism, user.authenticationMechanism) &&
        Objects.equals(this.changeDescription, user.changeDescription) &&
        Objects.equals(this.children, user.children) &&
        Objects.equals(this.dataProducts, user.dataProducts) &&
        Objects.equals(this.defaultPersona, user.defaultPersona) &&
        Objects.equals(this.deleted, user.deleted) &&
        Objects.equals(this.description, user.description) &&
        Objects.equals(this.displayName, user.displayName) &&
        Objects.equals(this.domain, user.domain) &&
        Objects.equals(this.email, user.email) &&
        Objects.equals(this.experts, user.experts) &&
        Objects.equals(this.extension, user.extension) &&
        Objects.equals(this.followers, user.followers) &&
        Objects.equals(this.follows, user.follows) &&
        Objects.equals(this.fullyQualifiedName, user.fullyQualifiedName) &&
        Objects.equals(this.href, user.href) &&
        Objects.equals(this.id, user.id) &&
        Objects.equals(this.inheritedRoles, user.inheritedRoles) &&
        Objects.equals(this.isAdmin, user.isAdmin) &&
        Objects.equals(this.isBot, user.isBot) &&
        Objects.equals(this.isEmailVerified, user.isEmailVerified) &&
        Objects.equals(this.lifeCycle, user.lifeCycle) &&
        Objects.equals(this.name, user.name) &&
        Objects.equals(this.owner, user.owner) &&
        Objects.equals(this.owns, user.owns) &&
        Objects.equals(this.personas, user.personas) &&
        Objects.equals(this.profile, user.profile) &&
        Objects.equals(this.provider, user.provider) &&
        Objects.equals(this.reviewers, user.reviewers) &&
        Objects.equals(this.roles, user.roles) &&
        Objects.equals(this.style, user.style) &&
        Objects.equals(this.tags, user.tags) &&
        Objects.equals(this.teams, user.teams) &&
        Objects.equals(this.timezone, user.timezone) &&
        Objects.equals(this.updatedAt, user.updatedAt) &&
        Objects.equals(this.updatedBy, user.updatedBy) &&
        Objects.equals(this.version, user.version) &&
        Objects.equals(this.votes, user.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationMechanism, changeDescription, children, dataProducts, defaultPersona, deleted, description, displayName, domain, email, experts, extension, followers, follows, fullyQualifiedName, href, id, inheritedRoles, isAdmin, isBot, isEmailVerified, lifeCycle, name, owner, owns, personas, profile, provider, reviewers, roles, style, tags, teams, timezone, updatedAt, updatedBy, version, votes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    authenticationMechanism: ").append(toIndentedString(authenticationMechanism)).append("\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    dataProducts: ").append(toIndentedString(dataProducts)).append("\n");
    sb.append("    defaultPersona: ").append(toIndentedString(defaultPersona)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    experts: ").append(toIndentedString(experts)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    follows: ").append(toIndentedString(follows)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inheritedRoles: ").append(toIndentedString(inheritedRoles)).append("\n");
    sb.append("    isAdmin: ").append(toIndentedString(isAdmin)).append("\n");
    sb.append("    isBot: ").append(toIndentedString(isBot)).append("\n");
    sb.append("    isEmailVerified: ").append(toIndentedString(isEmailVerified)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    owns: ").append(toIndentedString(owns)).append("\n");
    sb.append("    personas: ").append(toIndentedString(personas)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    teams: ").append(toIndentedString(teams)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

