/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateDashboardService;
import org.openmetadata.client.model.DashboardService;
import org.openmetadata.client.model.DashboardServiceList;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface DashboardServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResultWithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService createDashboardService(CreateDashboardService var1);

    @RequestLine(value="POST /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> createDashboardServiceWithHttpInfo(CreateDashboardService var1);

    @RequestLine(value="PUT /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService createOrUpdateDashboardService(CreateDashboardService var1);

    @RequestLine(value="PUT /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> createOrUpdateDashboardServiceWithHttpInfo(CreateDashboardService var1);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardService(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardService(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getSpecificDashboardServiceVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getSpecificDashboardServiceVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDashboardServiceVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDashboardServiceVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardServiceList listDashboardsService(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="domain") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardServiceList> listDashboardsServiceWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="domain") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardServiceList listDashboardsService(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardServiceList> listDashboardsServiceWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/services/dashboardServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboardService(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/dashboardServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboardServiceWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService restore20(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/dashboardServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> restore20WithHttpInfo(RestoreEntity var1);

    public static class ListDashboardsServiceQueryParams
    extends HashMap<String, Object> {
        public ListDashboardsServiceQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetDashboardServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDashboardServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardServiceByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

