/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateSearchIndex;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchIndex;
import org.openmetadata.client.model.SearchIndexList;
import org.openmetadata.client.model.SearchIndexSampleData;
import org.openmetadata.client.model.VoteRequest;

public interface SearchIndexApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/searchIndexes/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower4(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower4WithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex addSampleData1(@Param(value="id") UUID var1, SearchIndexSampleData var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> addSampleData1WithHttpInfo(@Param(value="id") UUID var1, SearchIndexSampleData var2);

    @RequestLine(value="PUT /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex createOrUpdateSearchIndex(CreateSearchIndex var1);

    @RequestLine(value="PUT /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> createOrUpdateSearchIndexWithHttpInfo(CreateSearchIndex var1);

    @RequestLine(value="POST /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex createSearchIndex(CreateSearchIndex var1);

    @RequestLine(value="POST /v1/searchIndexes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> createSearchIndexWithHttpInfo(CreateSearchIndex var1);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower5(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower5WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndex(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndex(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/searchIndexes/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchIndexByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/searchIndexes/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchIndexByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex get6(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> get6WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex get6(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> get6WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSampleData1(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSampleData1WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSearchIndexByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSearchIndexByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSearchIndexByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/searchIndexes/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSearchIndexByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public SearchIndex getSpecificSearchIndexVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndex> getSpecificSearchIndexVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSearchIndexVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/searchIndexes/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSearchIndexVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndexList listSearchIndexes(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndexList> listSearchIndexesWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchIndexList listSearchIndexes(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/searchIndexes?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchIndexList> listSearchIndexesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/searchIndexes/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchIndex(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/searchIndexes/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchIndexWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/searchIndexes/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchIndex restore19(RestoreEntity var1);

    @RequestLine(value="PUT /v1/searchIndexes/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchIndex> restore19WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity14(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/searchIndexes/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity14WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListSearchIndexesQueryParams
    extends HashMap<String, Object> {
        public ListSearchIndexesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchIndexesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchIndexByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSearchIndexByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchIndexByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get6QueryParams
    extends HashMap<String, Object> {
        public Get6QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get6QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchIndexByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchIndexByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchIndexQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchIndexQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

