/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateStoredProcedure;
import org.openmetadata.client.model.DatabaseSchema;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.StoredProcedure;
import org.openmetadata.client.model.StoredProcedureList;
import org.openmetadata.client.model.VoteRequest;

public interface StoredProceduresApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/storedProcedures/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StoredProcedure createOrUpdateStoredProcedure(CreateStoredProcedure var1);

    @RequestLine(value="PUT /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StoredProcedure> createOrUpdateStoredProcedureWithHttpInfo(CreateStoredProcedure var1);

    @RequestLine(value="POST /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StoredProcedure createStoredProcedure(CreateStoredProcedure var1);

    @RequestLine(value="POST /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StoredProcedure> createStoredProcedureWithHttpInfo(CreateStoredProcedure var1);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN1(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQN1WithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN1(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQN1WithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerWithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedure(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedure(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getSpecificStoredProcedureVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getSpecificStoredProcedureVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllStoredProceduresVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllStoredProceduresVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedureList listStoredProcedures(@Param(value="fields") String var1, @Param(value="databaseSchema") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedureList> listStoredProceduresWithHttpInfo(@Param(value="fields") String var1, @Param(value="databaseSchema") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedureList listStoredProcedures(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedureList> listStoredProceduresWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/storedProcedures/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStoredProcedure(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/storedProcedures/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStoredProcedureWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/storedProcedures/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema restore7(RestoreEntity var1);

    @RequestLine(value="PUT /v1/storedProcedures/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> restore7WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity4(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity4WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListStoredProceduresQueryParams
    extends HashMap<String, Object> {
        public ListStoredProceduresQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams databaseSchema(String value) {
            this.put("databaseSchema", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStoredProcedureByIDQueryParams
    extends HashMap<String, Object> {
        public GetStoredProcedureByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStoredProcedureByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStoredProcedureByFQNQueryParams
    extends HashMap<String, Object> {
        public GetStoredProcedureByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStoredProcedureByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStoredProcedureQueryParams
    extends HashMap<String, Object> {
        public DeleteStoredProcedureQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStoredProcedureQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaByFQN1QueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaByFQN1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

