/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.ChangePasswordRequest;
import org.openmetadata.client.model.CreatePersonalToken;
import org.openmetadata.client.model.CreateUser;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EmailRequest;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.GenerateTokenRequest;
import org.openmetadata.client.model.JWTAuthMechanism;
import org.openmetadata.client.model.JwtResponse;
import org.openmetadata.client.model.LoginRequest;
import org.openmetadata.client.model.LogoutRequest;
import org.openmetadata.client.model.PasswordResetRequest;
import org.openmetadata.client.model.PersonalAccessToken;
import org.openmetadata.client.model.PersonalAccessTokenList;
import org.openmetadata.client.model.RegistrationRequest;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.RevokePersonalTokenRequest;
import org.openmetadata.client.model.RevokeTokenRequest;
import org.openmetadata.client.model.TokenRefreshRequest;
import org.openmetadata.client.model.User;
import org.openmetadata.client.model.UserList;

public interface UsersApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/users/changePassword")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User changeUserPassword(ChangePasswordRequest var1);

    @RequestLine(value="PUT /v1/users/changePassword")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> changeUserPasswordWithHttpInfo(ChangePasswordRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailInUse")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Boolean checkEmailInUse(EmailRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailInUse")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Boolean> checkEmailInUseWithHttpInfo(EmailRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailVerified")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Boolean checkEmailIsVerified(EmailRequest var1);

    @RequestLine(value="POST /v1/users/checkEmailVerified")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Boolean> checkEmailIsVerifiedWithHttpInfo(EmailRequest var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public void confirmUserEmail(@Param(value="token") String var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> confirmUserEmailWithHttpInfo(@Param(value="token") String var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public void confirmUserEmail(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /v1/users/registrationConfirmation?token={token}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> confirmUserEmailWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateUser createOrUpdateUser(CreateUser var1);

    @RequestLine(value="PUT /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateUser> createOrUpdateUserWithHttpInfo(CreateUser var1);

    @RequestLine(value="PUT /v1/users/security/token")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessToken createPersonalAccessToken(CreatePersonalToken var1);

    @RequestLine(value="PUT /v1/users/security/token")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessToken> createPersonalAccessTokenWithHttpInfo(CreatePersonalToken var1);

    @RequestLine(value="POST /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User createUser(CreateUser var1);

    @RequestLine(value="POST /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> createUserWithHttpInfo(CreateUser var1);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUser(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUser(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/users/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public String exportUsers(@Param(value="team") String var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportUsersWithHttpInfo(@Param(value="team") String var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public String exportUsers(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/export?team={team}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportUsersWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /v1/users/generateToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public String generateJWTTokenForBotUser(@Param(value="id") UUID var1, GenerateTokenRequest var2);

    @RequestLine(value="PUT /v1/users/generateToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<String> generateJWTTokenForBotUserWithHttpInfo(@Param(value="id") UUID var1, GenerateTokenRequest var2);

    @RequestLine(value="POST /v1/users/generatePasswordResetLink")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void generatePasswordResetLink(EmailRequest var1);

    @RequestLine(value="POST /v1/users/generatePasswordResetLink")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> generatePasswordResetLinkWithHttpInfo(EmailRequest var1);

    @RequestLine(value="GET /v1/users/generateRandomPwd")
    @Headers(value={"Accept: application/json"})
    public void generateRandomPwd();

    @RequestLine(value="GET /v1/users/generateRandomPwd")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> generateRandomPwdWithHttpInfo();

    @RequestLine(value="GET /v1/users/auth-mechanism/{id}")
    @Headers(value={"Accept: application/json"})
    public AuthenticationMechanism getAuthenticationMechanismBotUser(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users/auth-mechanism/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AuthenticationMechanism> getAuthenticationMechanismBotUserWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation2();

    @RequestLine(value="GET /v1/users/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentation2WithHttpInfo();

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public User getCurrentLoggedInUser(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getCurrentLoggedInUserWithHttpInfo(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public User getCurrentLoggedInUser(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getCurrentLoggedInUserWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/loggedInUser/groupTeams")
    @Headers(value={"Accept: application/json"})
    public List<EntityReference> getCurrentLoggedInUserGroupTeams();

    @RequestLine(value="GET /v1/users/loggedInUser/groupTeams")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<EntityReference>> getCurrentLoggedInUserGroupTeamsWithHttpInfo();

    @RequestLine(value="GET /v1/users/token/{id}")
    @Headers(value={"Accept: application/json"})
    public JWTAuthMechanism getJWTTokenForBotUser(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users/token/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<JWTAuthMechanism> getJWTTokenForBotUserWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public PersonalAccessTokenList getPersonalAccessToken(@Param(value="username") String var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> getPersonalAccessTokenWithHttpInfo(@Param(value="username") String var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public PersonalAccessTokenList getPersonalAccessToken(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/security/token?username={username}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> getPersonalAccessTokenWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public User getSpecificUserVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/users/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getSpecificUserVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams1(@Param(value="team") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeams1WithHttpInfo(@Param(value="team") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams1(String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="PUT /v1/users/import?team={team}&dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeams1WithHttpInfo(String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllUserVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllUserVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public UserList listUsers(@Param(value="fields") String var1, @Param(value="team") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="isAdmin") Boolean var6, @Param(value="isBot") Boolean var7, @Param(value="include") String var8);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listUsersWithHttpInfo(@Param(value="fields") String var1, @Param(value="team") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="isAdmin") Boolean var6, @Param(value="isBot") Boolean var7, @Param(value="include") String var8);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public UserList listUsers(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserList> listUsersWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /v1/users/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JwtResponse loginUserWithPwd(LoginRequest var1);

    @RequestLine(value="POST /v1/users/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JwtResponse> loginUserWithPwdWithHttpInfo(LoginRequest var1);

    @RequestLine(value="POST /v1/users/logout")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void logoutUser(LogoutRequest var1);

    @RequestLine(value="POST /v1/users/logout")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> logoutUserWithHttpInfo(LogoutRequest var1);

    @RequestLine(value="PATCH /v1/users/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchUser(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/users/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchUserWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="POST /v1/users/refresh")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JwtResponse refreshToken(TokenRefreshRequest var1);

    @RequestLine(value="POST /v1/users/refresh")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JwtResponse> refreshTokenWithHttpInfo(TokenRefreshRequest var1);

    @RequestLine(value="POST /v1/users/signup")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void registerUser(RegistrationRequest var1);

    @RequestLine(value="POST /v1/users/signup")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> registerUserWithHttpInfo(RegistrationRequest var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public void resendRegistrationToken(@Param(value="user") String var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resendRegistrationTokenWithHttpInfo(@Param(value="user") String var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public void resendRegistrationToken(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /v1/users/resendRegistrationToken?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resendRegistrationTokenWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /v1/users/password/reset")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User resetUserPassword(PasswordResetRequest var1);

    @RequestLine(value="POST /v1/users/password/reset")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> resetUserPasswordWithHttpInfo(PasswordResetRequest var1);

    @RequestLine(value="PUT /v1/users/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User restore31(RestoreEntity var1);

    @RequestLine(value="PUT /v1/users/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> restore31WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/users/revokeToken")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JWTAuthMechanism revokeJWTTokenForBotUser(RevokeTokenRequest var1);

    @RequestLine(value="PUT /v1/users/revokeToken")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<JWTAuthMechanism> revokeJWTTokenForBotUserWithHttpInfo(RevokeTokenRequest var1);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessTokenList revokePersonalAccessToken(@Param(value="username") String var1, @Param(value="removeAll") Boolean var2, RevokePersonalTokenRequest var3);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> revokePersonalAccessTokenWithHttpInfo(@Param(value="username") String var1, @Param(value="removeAll") Boolean var2, RevokePersonalTokenRequest var3);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PersonalAccessTokenList revokePersonalAccessToken(RevokePersonalTokenRequest var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="PUT /v1/users/security/token/revoke?username={username}&removeAll={removeAll}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PersonalAccessTokenList> revokePersonalAccessTokenWithHttpInfo(RevokePersonalTokenRequest var1, @QueryMap(encoded=true) Map<String, Object> var2);

    public static class RevokePersonalAccessTokenQueryParams
    extends HashMap<String, Object> {
        public RevokePersonalAccessTokenQueryParams username(String value) {
            this.put("username", EncodingUtils.encode(value));
            return this;
        }

        public RevokePersonalAccessTokenQueryParams removeAll(Boolean value) {
            this.put("removeAll", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ResendRegistrationTokenQueryParams
    extends HashMap<String, Object> {
        public ResendRegistrationTokenQueryParams user(String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListUsersQueryParams
    extends HashMap<String, Object> {
        public ListUsersQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams team(String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isAdmin(Boolean value) {
            this.put("isAdmin", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isBot(Boolean value) {
            this.put("isBot", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeams1QueryParams
    extends HashMap<String, Object> {
        public ImportTeams1QueryParams team(String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ImportTeams1QueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByIDQueryParams
    extends HashMap<String, Object> {
        public GetUserByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByFQNQueryParams
    extends HashMap<String, Object> {
        public GetUserByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonalAccessTokenQueryParams
    extends HashMap<String, Object> {
        public GetPersonalAccessTokenQueryParams username(String value) {
            this.put("username", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetCurrentLoggedInUserQueryParams
    extends HashMap<String, Object> {
        public GetCurrentLoggedInUserQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportUsersQueryParams
    extends HashMap<String, Object> {
        public ExportUsersQueryParams team(String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteUserByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserQueryParams
    extends HashMap<String, Object> {
        public DeleteUserQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ConfirmUserEmailQueryParams
    extends HashMap<String, Object> {
        public ConfirmUserEmailQueryParams token(String value) {
            this.put("token", EncodingUtils.encode(value));
            return this;
        }
    }
}

