/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRequestInterceptor<K>
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRequestInterceptor.class);
    private final Class<K> type;
    final ObjectMapper mapper;

    public CustomRequestInterceptor(ObjectMapper mapper, Class<K> type) {
        this.type = type;
        this.mapper = mapper;
    }

    public void apply(RequestTemplate requestTemplate) {
        try {
            LOG.debug("Trying to Convert from generated class to org.openmetadata");
            String body = new String(requestTemplate.body());
            Object value = this.mapper.readValue(body, this.getType());
            requestTemplate.body(this.mapper.writeValueAsString(value));
        }
        catch (Exception ex) {
            LOG.error("[CustomInterceptor] Failed in transforming request with exception {}", (Object)ex.getMessage());
        }
    }

    public Class<K> getType() {
        return this.type;
    }
}

