/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"condition", "description", "effect", "fullyQualifiedName", "name", "operations", "resources"})
public class Rule {
    public static final String JSON_PROPERTY_CONDITION = "condition";
    private String condition;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EFFECT = "effect";
    private EffectEnum effect;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    private List<OperationsEnum> operations = new ArrayList<OperationsEnum>();
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<String> resources = new ArrayList<String>();

    public Rule condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Rule description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Rule effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="effect")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EffectEnum getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public Rule fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Rule name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Rule operations(List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public Rule addOperationsItem(OperationsEnum operationsItem) {
        this.operations.add(operationsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperations(List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public Rule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public Rule addResourcesItem(String resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.condition, rule.condition) && Objects.equals(this.description, rule.description) && Objects.equals((Object)this.effect, (Object)rule.effect) && Objects.equals(this.fullyQualifiedName, rule.fullyQualifiedName) && Objects.equals(this.name, rule.name) && Objects.equals(this.operations, rule.operations) && Objects.equals(this.resources, rule.resources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.description, this.effect, this.fullyQualifiedName, this.name, this.operations, this.resources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rule {\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EffectEnum {
        ALLOW("allow"),
        DENY("deny");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OperationsEnum {
        ALL("All"),
        CREATE("Create"),
        DELETE("Delete"),
        VIEWALL("ViewAll"),
        VIEWBASIC("ViewBasic"),
        VIEWUSAGE("ViewUsage"),
        VIEWTESTS("ViewTests"),
        VIEWQUERIES("ViewQueries"),
        VIEWDATAPROFILE("ViewDataProfile"),
        VIEWSAMPLEDATA("ViewSampleData"),
        EDITALL("EditAll"),
        EDITCUSTOMFIELDS("EditCustomFields"),
        EDITDATAPROFILE("EditDataProfile"),
        EDITDESCRIPTION("EditDescription"),
        EDITDISPLAYNAME("EditDisplayName"),
        EDITLINEAGE("EditLineage"),
        EDITPOLICY("EditPolicy"),
        EDITOWNER("EditOwner"),
        EDITQUERIES("EditQueries"),
        EDITREVIEWERS("EditReviewers"),
        EDITROLE("EditRole"),
        EDITSAMPLEDATA("EditSampleData"),
        EDITSTATUS("EditStatus"),
        EDITTAGS("EditTags"),
        EDITTEAMS("EditTeams"),
        EDITTIER("EditTier"),
        EDITTESTS("EditTests"),
        EDITUSAGE("EditUsage"),
        EDITUSERS("EditUsers"),
        EDITLIFECYCLE("EditLifeCycle"),
        EDITKNOWLEDGEPANEL("EditKnowledgePanel"),
        EDITPAGE("EditPage");

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String value) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

