/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import com.google.common.collect.ImmutableSet;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import feign.RequestTemplate;
import java.io.IOException;
import java.util.Set;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.openmetadata.schema.security.client.AzureSSOClientConfig;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AzureAuthenticationProvider.class);
    private final AzureSSOClientConfig securityConfig;
    private String generatedAuthToken;
    private Long expirationTimeMillis;

    public AzureAuthenticationProvider(OpenMetadataConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)AuthProvider.AZURE)) {
            LOG.error("Required type to invoke is Azure for AzureAuthentication Provider");
            throw new RuntimeException("Required type to invoke is Azure for AzureAuthentication Provider");
        }
        this.securityConfig = (AzureSSOClientConfig)iConfig.getSecurityConfig();
        if (this.securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
    }

    @Override
    public AuthenticationProvider create(OpenMetadataConnection iConfig) {
        return new AzureAuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() throws IOException {
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)this.securityConfig.getClientSecret());
        ConfidentialClientApplication cca = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.securityConfig.getClientId(), (IClientCredential)credential).authority(this.securityConfig.getAuthority())).build();
        ImmutableSet scope = ImmutableSet.of((Object)("api://" + this.securityConfig.getClientId() + "/.default"));
        ClientCredentialParameters parameters = ClientCredentialParameters.builder((Set)scope).build();
        IAuthenticationResult result = (IAuthenticationResult)cca.acquireToken(parameters).join();
        this.generatedAuthToken = result.accessToken();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            try {
                this.authToken();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

