/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDashboard;
import org.openmetadata.client.model.Dashboard;
import org.openmetadata.client.model.DashboardList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DashboardsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dashboards/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addFollowerToDashboard(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/dashboards/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addFollowerToDashboardWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createDashboard(CreateDashboard var1);

    @RequestLine(value="POST /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> createDashboardWithHttpInfo(CreateDashboard var1);

    @RequestLine(value="PUT /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createOrUpdateDashboard(CreateDashboard var1);

    @RequestLine(value="PUT /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> createOrUpdateDashboardWithHttpInfo(CreateDashboard var1);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboard(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboard(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getSpecificDashboardVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getSpecificDashboardVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDashboardVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dashboards/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDashboardVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardList listDashboards(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardList> listDashboardsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardList listDashboards(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardList> listDashboardsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/dashboards/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboard(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dashboards/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboardWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public void removeFollowerFromDashboard(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeFollowerFromDashboardWithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="PUT /v1/dashboards/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard restore4(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboards/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> restore4WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboards/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity1(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/dashboards/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity1WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListDashboardsQueryParams
    extends HashMap<String, Object> {
        public ListDashboardsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByIDQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

