/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateStorageService;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.StorageService;
import org.openmetadata.client.model.StorageServiceList;
import org.openmetadata.client.model.TestConnectionResult;

public interface ObjectStoreServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/storageServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult7(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/storageServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResult7WithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService createOrUpdateStorageService(CreateStorageService var1);

    @RequestLine(value="PUT /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> createOrUpdateStorageServiceWithHttpInfo(CreateStorageService var1);

    @RequestLine(value="POST /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService createStorageService(CreateStorageService var1);

    @RequestLine(value="POST /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> createStorageServiceWithHttpInfo(CreateStorageService var1);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageService(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceWithHttpInfo(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageService(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceWithHttpInfo(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceByFQN(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public StorageService getSpecificStorageServiceVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getSpecificStorageServiceVersionWithHttpInfo(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllStorageServiceVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllStorageServiceVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageServiceList listStorageServices(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageServiceList> listStorageServicesWithHttpInfo(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageServiceList listStorageServices(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageServiceList> listStorageServicesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/services/storageServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStorageService(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/storageServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStorageServiceWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/storageServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService restore27(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/storageServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> restore27WithHttpInfo(RestoreEntity var1);

    public static class ListStorageServicesQueryParams
    extends HashMap<String, Object> {
        public ListStorageServicesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStorageServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetStorageServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStorageServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStorageServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetStorageServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStorageServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStorageServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteStorageServiceByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStorageServiceByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStorageServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteStorageServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStorageServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

