/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreatePipeline;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Pipeline;
import org.openmetadata.client.model.PipelineList;
import org.openmetadata.client.model.PipelineStatus;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestCaseList;
import org.openmetadata.client.model.VoteRequest;

public interface PipelinesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/pipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower2(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/pipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower2WithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/pipelines/{fqn}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline addStatusData(@Param(value="fqn") String var1, PipelineStatus var2);

    @RequestLine(value="PUT /v1/pipelines/{fqn}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> addStatusDataWithHttpInfo(@Param(value="fqn") String var1, PipelineStatus var2);

    @RequestLine(value="PUT /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createOrUpdatePipeline(CreatePipeline var1);

    @RequestLine(value="PUT /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> createOrUpdatePipelineWithHttpInfo(CreatePipeline var1);

    @RequestLine(value="POST /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createPipeline(CreatePipeline var1);

    @RequestLine(value="POST /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> createPipelineWithHttpInfo(CreatePipeline var1);

    @RequestLine(value="DELETE /v1/pipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower3(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower3WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipeline(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipeline(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/pipelines/{fqn}/status/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public Pipeline deletePipelineStatus(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="DELETE /v1/pipelines/{fqn}/status/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> deletePipelineStatusWithHttpInfo(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineWithIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineWithIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getSpecificPipelineVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getSpecificPipelineVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPipelineVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/pipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPipelineVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listPipelineStatuses(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listPipelineStatusesWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listPipelineStatuses(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listPipelineStatusesWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineList listPipelines(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineList> listPipelinesWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineList listPipelines(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineList> listPipelinesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/pipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipeline(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/pipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipelineWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/pipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline restore16(RestoreEntity var1);

    @RequestLine(value="PUT /v1/pipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> restore16WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/pipelines/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity11(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/pipelines/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity11WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListPipelinesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListPipelineStatusesQueryParams
    extends HashMap<String, Object> {
        public ListPipelineStatusesQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineStatusesQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineWithIDQueryParams
    extends HashMap<String, Object> {
        public GetPipelineWithIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineWithIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPipelineByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

