/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.ColumnProfileList;
import org.openmetadata.client.model.CreateCustomMetric;
import org.openmetadata.client.model.CreateTable;
import org.openmetadata.client.model.CreateTableProfile;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SystemProfileList;
import org.openmetadata.client.model.Table;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TableList;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfileList;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.VoteRequest;

public interface TablesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/tables/{id}/customMetric")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addCustomMetric(@Param(value="id") UUID var1, CreateCustomMetric var2);

    @RequestLine(value="PUT /v1/tables/{id}/customMetric")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addCustomMetricWithHttpInfo(@Param(value="id") UUID var1, CreateCustomMetric var2);

    @RequestLine(value="PUT /v1/tables/{id}/dataModel")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataModel(@Param(value="id") String var1, DataModel var2);

    @RequestLine(value="PUT /v1/tables/{id}/dataModel")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataModelWithHttpInfo(@Param(value="id") String var1, DataModel var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataProfiler(@Param(value="id") UUID var1, CreateTableProfile var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataProfilerWithHttpInfo(@Param(value="id") UUID var1, CreateTableProfile var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataProfilerConfig2(@Param(value="id") UUID var1, TableProfilerConfig var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataProfilerConfig2WithHttpInfo(@Param(value="id") UUID var1, TableProfilerConfig var2);

    @RequestLine(value="PUT /v1/tables/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToTable(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/tables/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToTableWithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/tables/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addSampleData(@Param(value="id") UUID var1, TableData var2);

    @RequestLine(value="PUT /v1/tables/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addSampleDataWithHttpInfo(@Param(value="id") UUID var1, TableData var2);

    @RequestLine(value="PUT /v1/tables/{id}/joins")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addTableJoinInfo(@Param(value="id") UUID var1, TableJoins var2);

    @RequestLine(value="PUT /v1/tables/{id}/joins")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addTableJoinInfoWithHttpInfo(@Param(value="id") UUID var1, TableJoins var2);

    @RequestLine(value="PUT /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createOrUpdateTable(CreateTable var1);

    @RequestLine(value="PUT /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> createOrUpdateTableWithHttpInfo(CreateTable var1);

    @RequestLine(value="POST /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createTable(CreateTable var1);

    @RequestLine(value="POST /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> createTableWithHttpInfo(CreateTable var1);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public Table deleteCustomMetric(@Param(value="id") UUID var1, @Param(value="columnName") String var2, @Param(value="customMetricName") String var3);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteCustomMetricWithHttpInfo(@Param(value="id") UUID var1, @Param(value="columnName") String var2, @Param(value="customMetricName") String var3);

    @RequestLine(value="DELETE /v1/tables/{fqn}/{entityType}/{timestamp}/profile")
    @Headers(value={"Accept: application/json"})
    public TableProfile deleteDataProfiler(@Param(value="fqn") String var1, @Param(value="entityType") String var2, @Param(value="timestamp") Long var3);

    @RequestLine(value="DELETE /v1/tables/{fqn}/{entityType}/{timestamp}/profile")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfile> deleteDataProfilerWithHttpInfo(@Param(value="fqn") String var1, @Param(value="entityType") String var2, @Param(value="timestamp") Long var3);

    @RequestLine(value="DELETE /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Table deleteDataProfilerConfig2(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteDataProfilerConfig2WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower1(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Table deleteSampleData(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteSampleDataWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable1(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTable1WithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable1(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTable1WithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Table getDataProfilerConfig2(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getDataProfilerConfig2WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Table getSampleData(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getSampleDataWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Table getSpecificDatabaseVersion1(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tables/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getSpecificDatabaseVersion1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest")
    @Headers(value={"Accept: application/json"})
    public Table getTheLatestTableAndColumnProfile(@Param(value="fqn") String var1);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTheLatestTableAndColumnProfileWithHttpInfo(@Param(value="fqn") String var1);

    @RequestLine(value="GET /v1/tables/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTableVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/tables/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTableVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ColumnProfileList listColumnProfiles(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ColumnProfileList> listColumnProfilesWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ColumnProfileList listColumnProfiles(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ColumnProfileList> listColumnProfilesWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TableProfileList listProfiles(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfileList> listProfilesWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TableProfileList listProfiles(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfileList> listProfilesWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public SystemProfileList listSystemProfiles(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SystemProfileList> listSystemProfilesWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public SystemProfileList listSystemProfiles(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SystemProfileList> listSystemProfilesWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableList listTables(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="databaseSchema") String var3, @Param(value="includeEmptyTestSuite") Boolean var4, @Param(value="limit") Integer var5, @Param(value="before") String var6, @Param(value="after") String var7, @Param(value="include") String var8);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableList> listTablesWithHttpInfo(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="databaseSchema") String var3, @Param(value="includeEmptyTestSuite") Boolean var4, @Param(value="limit") Integer var5, @Param(value="before") String var6, @Param(value="after") String var7, @Param(value="include") String var8);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableList listTables(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableList> listTablesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/tables/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/tables/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTableWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/tables/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table restore8(RestoreEntity var1);

    @RequestLine(value="PUT /v1/tables/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> restore8WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/tables/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity5(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/tables/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity5WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListTablesQueryParams
    extends HashMap<String, Object> {
        public ListTablesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams database(String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams databaseSchema(String value) {
            this.put("databaseSchema", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams includeEmptyTestSuite(Boolean value) {
            this.put("includeEmptyTestSuite", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListSystemProfilesQueryParams
    extends HashMap<String, Object> {
        public ListSystemProfilesQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListSystemProfilesQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListProfilesQueryParams
    extends HashMap<String, Object> {
        public ListProfilesQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListProfilesQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListColumnProfilesQueryParams
    extends HashMap<String, Object> {
        public ListColumnProfilesQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListColumnProfilesQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByIDQueryParams
    extends HashMap<String, Object> {
        public GetTableByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTableByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTable1QueryParams
    extends HashMap<String, Object> {
        public DeleteTable1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTable1QueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTableQueryParams
    extends HashMap<String, Object> {
        public DeleteTableQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTableQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

