/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.BulkAssets;
import org.openmetadata.client.model.BulkOperationResult;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateTeam;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Team;
import org.openmetadata.client.model.TeamList;

public interface TeamsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/teams/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddAssets2(@Param(value="name") String var1, BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddAssets2WithHttpInfo(@Param(value="name") String var1, BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveAssets2(@Param(value="name") String var1, BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveAssets2WithHttpInfo(@Param(value="name") String var1, BulkAssets var2);

    @RequestLine(value="PUT /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createOrUpdateTeam(CreateTeam var1);

    @RequestLine(value="PUT /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> createOrUpdateTeamWithHttpInfo(CreateTeam var1);

    @RequestLine(value="POST /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createTeam(CreateTeam var1);

    @RequestLine(value="POST /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> createTeamWithHttpInfo(CreateTeam var1);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeam(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeam(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportTeams(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/teams/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportTeamsWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/teams/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation1(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/teams/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentation1WithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/teams/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Team getSpecificTeamVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/teams/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getSpecificTeamVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="GET /v1/teams/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTeamVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/teams/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTeamVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeams(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="parentTeam") String var5, @Param(value="isJoinable") Boolean var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="parentTeam") String var5, @Param(value="isJoinable") Boolean var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeams(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeamsHierarchy(@Param(value="limit") Integer var1, @Param(value="isJoinable") Boolean var2);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsHierarchyWithHttpInfo(@Param(value="limit") Integer var1, @Param(value="isJoinable") Boolean var2);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeamsHierarchy(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsHierarchyWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/teams/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTeam(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/teams/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTeamWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/teams/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team restore30(RestoreEntity var1);

    @RequestLine(value="PUT /v1/teams/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> restore30WithHttpInfo(RestoreEntity var1);

    public static class ListTeamsHierarchyQueryParams
    extends HashMap<String, Object> {
        public ListTeamsHierarchyQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsHierarchyQueryParams isJoinable(Boolean value) {
            this.put("isJoinable", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTeamsQueryParams
    extends HashMap<String, Object> {
        public ListTeamsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams parentTeam(String value) {
            this.put("parentTeam", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams isJoinable(Boolean value) {
            this.put("isJoinable", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeamsQueryParams
    extends HashMap<String, Object> {
        public ImportTeamsQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByIDQueryParams
    extends HashMap<String, Object> {
        public GetTeamByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTeamByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTeamQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

