/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateTestSuite;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.TestSuiteList;
import org.openmetadata.client.model.TestSummary;

public interface TestSuitesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createExecutableTestSuite(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createExecutableTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createLogicalTestSuite(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createLogicalTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateExecutableTestSuite(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateExecutableTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateLogicalTestSuite(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateLogicalTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@Param(value="testSuiteId") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@Param(value="testSuiteId") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getSpecificTestSuiteVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getSpecificTestSuiteVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestSuiteVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestSuiteVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="testSuiteType") String var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="testSuiteType") String var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestSuite(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestSuiteWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite restore12(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> restore12WithHttpInfo(RestoreEntity var1);

    public static class ListTestSuitesQueryParams
    extends HashMap<String, Object> {
        public ListTestSuitesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams testSuiteType(String value) {
            this.put("testSuiteType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestSuiteByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestSuiteByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetExecutionSummaryOfTestSuitesQueryParams
    extends HashMap<String, Object> {
        public GetExecutionSummaryOfTestSuitesQueryParams testSuiteId(UUID value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get5QueryParams
    extends HashMap<String, Object> {
        public Get5QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get5QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteByNameQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuite1QueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuite1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuiteQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

