/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "supportedFilters"})
public class SubscriptionResourceDescriptor {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SUPPORTED_FILTERS = "supportedFilters";
    private List<SupportedFiltersEnum> supportedFilters = null;

    public SubscriptionResourceDescriptor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SubscriptionResourceDescriptor supportedFilters(List<SupportedFiltersEnum> supportedFilters) {
        this.supportedFilters = supportedFilters;
        return this;
    }

    public SubscriptionResourceDescriptor addSupportedFiltersItem(SupportedFiltersEnum supportedFiltersItem) {
        if (this.supportedFilters == null) {
            this.supportedFilters = new ArrayList<SupportedFiltersEnum>();
        }
        this.supportedFilters.add(supportedFiltersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="supportedFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SupportedFiltersEnum> getSupportedFilters() {
        return this.supportedFilters;
    }

    @JsonProperty(value="supportedFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedFilters(List<SupportedFiltersEnum> supportedFilters) {
        this.supportedFilters = supportedFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionResourceDescriptor subscriptionResourceDescriptor = (SubscriptionResourceDescriptor)o;
        return Objects.equals(this.name, subscriptionResourceDescriptor.name) && Objects.equals(this.supportedFilters, subscriptionResourceDescriptor.supportedFilters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.supportedFilters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionResourceDescriptor {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedFilters: ").append(this.toIndentedString(this.supportedFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupportedFiltersEnum {
        MATCHANYSOURCE("matchAnySource"),
        MATCHANYOWNERNAME("matchAnyOwnerName"),
        MATCHANYENTITYFQN("matchAnyEntityFqn"),
        MATCHANYENTITYID("matchAnyEntityId"),
        MATCHANYEVENTTYPE("matchAnyEventType"),
        MATCHTESTRESULT("matchTestResult"),
        MATCHUPDATEDBY("matchUpdatedBy"),
        MATCHINGESTIONPIPELINESTATE("matchIngestionPipelineState"),
        MATCHANYFIELDCHANGE("matchAnyFieldChange");

        private String value;

        private SupportedFiltersEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportedFiltersEnum fromValue(String value) {
            for (SupportedFiltersEnum b : SupportedFiltersEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

