/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateDocument;
import org.openmetadata.client.model.Document;
import org.openmetadata.client.model.DocumentList;
import org.openmetadata.client.model.EntityHistory;

public interface DocumentStoreApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/docStore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Document createDocument(CreateDocument var1);

    @RequestLine(value="POST /v1/docStore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Document> createDocumentWithHttpInfo(CreateDocument var1);

    @RequestLine(value="PUT /v1/docStore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Document createOrUpdateDocument(CreateDocument var1);

    @RequestLine(value="PUT /v1/docStore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Document> createOrUpdateDocumentWithHttpInfo(CreateDocument var1);

    @RequestLine(value="DELETE /v1/docStore/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteDocument(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/docStore/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDocumentWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/docStore/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteDocumentByName(@Param(value="name") String var1);

    @RequestLine(value="DELETE /v1/docStore/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDocumentByNameWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/docStore/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Document get2(@Param(value="id") UUID var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/docStore/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Document> get2WithHttpInfo(@Param(value="id") UUID var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/docStore/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Document get2(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get2QueryParams var2);

    @RequestLine(value="GET /v1/docStore/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Document> get2WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get2QueryParams var2);

    @RequestLine(value="GET /v1/docStore/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Document getDocumentByFQN(@Param(value="name") String var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/docStore/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Document> getDocumentByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/docStore/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Document getDocumentByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) GetDocumentByFQNQueryParams var2);

    @RequestLine(value="GET /v1/docStore/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Document> getDocumentByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetDocumentByFQNQueryParams var2);

    @RequestLine(value="GET /v1/docStore/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Document getSpecificDocumentVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/docStore/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Document> getSpecificDocumentVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/docStore/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDocumentVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/docStore/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDocumentVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/docStore?limit={limit}&entityType={entityType}&fqnPrefix={fqnPrefix}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DocumentList listDocuments(@Param(value="limit") Integer var1, @Param(value="entityType") String var2, @Param(value="fqnPrefix") String var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/docStore?limit={limit}&entityType={entityType}&fqnPrefix={fqnPrefix}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DocumentList> listDocumentsWithHttpInfo(@Param(value="limit") Integer var1, @Param(value="entityType") String var2, @Param(value="fqnPrefix") String var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/docStore?limit={limit}&entityType={entityType}&fqnPrefix={fqnPrefix}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DocumentList listDocuments(@QueryMap(encoded=true) ListDocumentsQueryParams var1);

    @RequestLine(value="GET /v1/docStore?limit={limit}&entityType={entityType}&fqnPrefix={fqnPrefix}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DocumentList> listDocumentsWithHttpInfo(@QueryMap(encoded=true) ListDocumentsQueryParams var1);

    @RequestLine(value="PATCH /v1/docStore/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDocument(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/docStore/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDocumentWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    public static class ListDocumentsQueryParams
    extends HashMap<String, Object> {
        public ListDocumentsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDocumentsQueryParams entityType(String value) {
            this.put("entityType", EncodingUtils.encode(value));
            return this;
        }

        public ListDocumentsQueryParams fqnPrefix(String value) {
            this.put("fqnPrefix", EncodingUtils.encode(value));
            return this;
        }

        public ListDocumentsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDocumentsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDocumentByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDocumentByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get2QueryParams
    extends HashMap<String, Object> {
        public Get2QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

