/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateEventSubscription;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EventList;
import org.openmetadata.client.model.EventSubscription;
import org.openmetadata.client.model.EventSubscriptionList;
import org.openmetadata.client.model.ResultListFilterResourceDescriptor;
import org.openmetadata.client.model.SubscriptionStatus;

public interface EventsApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/events/subscriptions/{id}/processedEvents")
    @Headers(value={"Accept: application/json"})
    public EntityHistory checkIfThePublisherProcessedALlEvents(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/processedEvents")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> checkIfThePublisherProcessedALlEventsWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateEventSubscription createEventSubscription(CreateEventSubscription var1);

    @RequestLine(value="POST /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateEventSubscription> createEventSubscriptionWithHttpInfo(CreateEventSubscription var1);

    @RequestLine(value="PUT /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateEventSubscription createOrUpdateEventSubscription(CreateEventSubscription var1);

    @RequestLine(value="PUT /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateEventSubscription> createOrUpdateEventSubscriptionWithHttpInfo(CreateEventSubscription var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/{id}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription deleteEventSubscription(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> deleteEventSubscriptionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteEventSubscriptionByName(@Param(value="name") String var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteEventSubscriptionByNameWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByID(@Param(value="id") UUID var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetEventSubscriptionByIDQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetEventSubscriptionByIDQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByName(@Param(value="eventSubscriptionName") String var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") String var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByName(@Param(value="eventSubscriptionName") String var1, @QueryMap(encoded=true) GetEventSubscriptionByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") String var1, @QueryMap(encoded=true) GetEventSubscriptionByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public SubscriptionStatus getEventSubscriptionStatus(@Param(value="eventSubscriptionName") String var1, @Param(value="destinationId") UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionStatus> getEventSubscriptionStatusWithHttpInfo(@Param(value="eventSubscriptionName") String var1, @Param(value="destinationId") UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/{eventSubscriptionId}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public SubscriptionStatus getEventSubscriptionStatusById(@Param(value="eventSubscriptionId") UUID var1, @Param(value="destinationId") UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/{eventSubscriptionId}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionStatus> getEventSubscriptionStatusByIdWithHttpInfo(@Param(value="eventSubscriptionId") UUID var1, @Param(value="destinationId") UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getSpecificEventSubscriptionVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getSpecificEventSubscriptionVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllEventSubscriptionVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllEventSubscriptionVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public EventList listChangeEvents(@Param(value="timestamp") Long var1, @Param(value="entityCreated") String var2, @Param(value="entityUpdated") String var3, @Param(value="entityRestored") String var4, @Param(value="entityDeleted") String var5);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventList> listChangeEventsWithHttpInfo(@Param(value="timestamp") Long var1, @Param(value="entityCreated") String var2, @Param(value="entityUpdated") String var3, @Param(value="entityRestored") String var4, @Param(value="entityDeleted") String var5);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public EventList listChangeEvents(@QueryMap(encoded=true) ListChangeEventsQueryParams var1);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventList> listChangeEventsWithHttpInfo(@QueryMap(encoded=true) ListChangeEventsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions/{alertType}/resources")
    @Headers(value={"Accept: application/json"})
    public ResultListFilterResourceDescriptor listEventSubscriptionResources(@Param(value="alertType") String var1);

    @RequestLine(value="GET /v1/events/subscriptions/{alertType}/resources")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultListFilterResourceDescriptor> listEventSubscriptionResourcesWithHttpInfo(@Param(value="alertType") String var1);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionList listEventSubscriptions(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="alertType") String var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionList> listEventSubscriptionsWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="alertType") String var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionList listEventSubscriptions(@QueryMap(encoded=true) ListEventSubscriptionsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionList> listEventSubscriptionsWithHttpInfo(@QueryMap(encoded=true) ListEventSubscriptionsQueryParams var1);

    @RequestLine(value="PATCH /v1/events/subscriptions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchEventSubscription(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/events/subscriptions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchEventSubscriptionWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="GET /v1/events/subscriptions/validation/condition/{expression}")
    @Headers(value={"Accept: application/json"})
    public void validateCondition(@Param(value="expression") String var1);

    @RequestLine(value="GET /v1/events/subscriptions/validation/condition/{expression}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> validateConditionWithHttpInfo(@Param(value="expression") String var1);

    public static class ListEventSubscriptionsQueryParams
    extends HashMap<String, Object> {
        public ListEventSubscriptionsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams alertType(String value) {
            this.put("alertType", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListChangeEventsQueryParams
    extends HashMap<String, Object> {
        public ListChangeEventsQueryParams entityCreated(String value) {
            this.put("entityCreated", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityUpdated(String value) {
            this.put("entityUpdated", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityRestored(String value) {
            this.put("entityRestored", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityDeleted(String value) {
            this.put("entityDeleted", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams timestamp(Long value) {
            this.put("timestamp", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionByNameQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionByIDQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

