/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AddLineage;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.EntityLineage;
import org.openmetadata.client.model.SearchResponse;

public interface LineageApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/lineage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addLineageEdge(AddLineage var1);

    @RequestLine(value="PUT /v1/lineage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addLineageEdgeWithHttpInfo(AddLineage var1);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Accept: application/json"})
    public void deleteLineageEdge(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLineageEdgeWithHttpInfo(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineage(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineage(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetLineageQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetLineageQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetLineageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetLineageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineage(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineage(@QueryMap(encoded=true) SearchLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithHttpInfo(@QueryMap(encoded=true) SearchLineageQueryParams var1);

    public static class SearchLineageQueryParams
    extends HashMap<String, Object> {
        public SearchLineageQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLineageByFQNQueryParams
    extends HashMap<String, Object> {
        public GetLineageByFQNQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public GetLineageByFQNQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLineageQueryParams
    extends HashMap<String, Object> {
        public GetLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public GetLineageQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }
    }
}

