/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreatePersona;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Persona;
import org.openmetadata.client.model.PersonaList;

public interface PersonasApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Persona createOrUpdatePersona(CreatePersona var1);

    @RequestLine(value="PUT /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Persona> createOrUpdatePersonaWithHttpInfo(CreatePersona var1);

    @RequestLine(value="POST /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Persona createPersona(CreatePersona var1);

    @RequestLine(value="POST /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Persona> createPersonaWithHttpInfo(CreatePersona var1);

    @RequestLine(value="DELETE /v1/personas/{id}")
    @Headers(value={"Accept: application/json"})
    public void deletePersona(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/personas/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePersonaWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/personas/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deletePersonaByName(@Param(value="name") String var1);

    @RequestLine(value="DELETE /v1/personas/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePersonaByNameWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) GetPersonaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetPersonaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetPersonaByIDQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetPersonaByIDQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Persona getSpecificPersonaVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/personas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getSpecificPersonaVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/personas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPersonaVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/personas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPersonaVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public PersonaList listPersonas(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonaList> listPersonasWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public PersonaList listPersonas(@QueryMap(encoded=true) ListPersonasQueryParams var1);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonaList> listPersonasWithHttpInfo(@QueryMap(encoded=true) ListPersonasQueryParams var1);

    @RequestLine(value="PATCH /v1/personas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPersona(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/personas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPersonaWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    public static class ListPersonasQueryParams
    extends HashMap<String, Object> {
        public ListPersonasQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonaByIDQueryParams
    extends HashMap<String, Object> {
        public GetPersonaByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPersonaByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonaByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPersonaByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPersonaByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

