/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreatePipelineService;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.PipelineService;
import org.openmetadata.client.model.PipelineServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface PipelineServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult5(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResult5WithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService createOrUpdatePipelineService(CreatePipelineService var1);

    @RequestLine(value="PUT /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> createOrUpdatePipelineServiceWithHttpInfo(CreatePipelineService var1);

    @RequestLine(value="POST /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService createPipelineService(CreatePipelineService var1);

    @RequestLine(value="POST /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> createPipelineServiceWithHttpInfo(CreatePipelineService var1);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineService(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineService(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeletePipelineServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeletePipelineServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceByName(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeletePipelineServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeletePipelineServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetPipelineServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetPipelineServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetPipelineServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetPipelineServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getSpecificPipelineService(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getSpecificPipelineServiceWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPipelineServiceVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPipelineServiceVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceList listPipelineService(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceList> listPipelineServiceWithHttpInfo(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceList listPipelineService(@QueryMap(encoded=true) ListPipelineServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceList> listPipelineServiceWithHttpInfo(@QueryMap(encoded=true) ListPipelineServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/pipelineServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipelineService(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/pipelineServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipelineServiceWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService restore25(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/pipelineServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> restore25WithHttpInfo(RestoreEntity var1);

    public static class ListPipelineServiceQueryParams
    extends HashMap<String, Object> {
        public ListPipelineServiceQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetPipelineServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPipelineServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineServiceByNameQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineServiceByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineServiceQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

