/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateSuggestion;
import org.openmetadata.client.model.Suggestion;
import org.openmetadata.client.model.SuggestionList;

public interface SuggestionsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/suggestions/{id}/accept")
    @Headers(value={"Accept: application/json"})
    public Suggestion acceptSuggestion(@Param(value="id") String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/accept")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> acceptSuggestionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="POST /v1/suggestions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Suggestion createSuggestion(CreateSuggestion var1);

    @RequestLine(value="POST /v1/suggestions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Suggestion> createSuggestionWithHttpInfo(CreateSuggestion var1);

    @RequestLine(value="DELETE /v1/suggestions/{suggestionId}")
    @Headers(value={"Accept: application/json"})
    public void deleteSuggestion(@Param(value="suggestionId") String var1);

    @RequestLine(value="DELETE /v1/suggestions/{suggestionId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSuggestionWithHttpInfo(@Param(value="suggestionId") String var1);

    @RequestLine(value="DELETE /v1/suggestions/{entityType}/name/{entityFQN}")
    @Headers(value={"Accept: application/json"})
    public void deleteSuggestions(@Param(value="entityType") String var1, @Param(value="entityFQN") String var2);

    @RequestLine(value="DELETE /v1/suggestions/{entityType}/name/{entityFQN}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSuggestionsWithHttpInfo(@Param(value="entityType") String var1, @Param(value="entityFQN") String var2);

    @RequestLine(value="GET /v1/suggestions/{id}")
    @Headers(value={"Accept: application/json"})
    public Suggestion getSuggestionByID(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/suggestions/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> getSuggestionByIDWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public SuggestionList listSuggestions(@Param(value="limit") Integer var1, @Param(value="before") String var2, @Param(value="after") String var3, @Param(value="entityFQN") String var4, @Param(value="userId") String var5, @Param(value="status") String var6);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SuggestionList> listSuggestionsWithHttpInfo(@Param(value="limit") Integer var1, @Param(value="before") String var2, @Param(value="after") String var3, @Param(value="entityFQN") String var4, @Param(value="userId") String var5, @Param(value="status") String var6);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public SuggestionList listSuggestions(@QueryMap(encoded=true) ListSuggestionsQueryParams var1);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SuggestionList> listSuggestionsWithHttpInfo(@QueryMap(encoded=true) ListSuggestionsQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/reject")
    @Headers(value={"Accept: application/json"})
    public Suggestion rejectSuggestion(@Param(value="id") String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/reject")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> rejectSuggestionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateSuggestion(@Param(value="id") String var1, Suggestion var2);

    @RequestLine(value="PUT /v1/suggestions/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateSuggestionWithHttpInfo(@Param(value="id") String var1, Suggestion var2);

    public static class ListSuggestionsQueryParams
    extends HashMap<String, Object> {
        public ListSuggestionsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams entityFQN(String value) {
            this.put("entityFQN", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams userId(String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams status(String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }
    }
}

