/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateLogicalTestCases;
import org.openmetadata.client.model.CreateTestCase;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestCase;
import org.openmetadata.client.model.TestCaseList;
import org.openmetadata.client.model.TestCaseResult;
import org.openmetadata.client.model.TestCaseResultList;
import org.openmetadata.client.model.TestSuite;

public interface TestCasesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dataQuality/testCases/{fqn}/testCaseResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase addTestCaseResult(@Param(value="fqn") String var1, TestCaseResult var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{fqn}/testCaseResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> addTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, TestCaseResult var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/logicalTestCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite addTestCasesToLogicalTestSuite(CreateLogicalTestCases var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases/logicalTestCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> addTestCasesToLogicalTestSuiteWithHttpInfo(CreateLogicalTestCases var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase createOrUpdateTest(CreateTestCase var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> createOrUpdateTestWithHttpInfo(CreateTestCase var1);

    @RequestLine(value="POST /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase createTestCase(CreateTestCase var1);

    @RequestLine(value="POST /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> createTestCaseWithHttpInfo(CreateTestCase var1);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/logicalTestCases/{testSuiteId}/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestCase(@Param(value="testSuiteId") UUID var1, @Param(value="id") UUID var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/logicalTestCases/{testSuiteId}/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestCaseWithHttpInfo(@Param(value="testSuiteId") UUID var1, @Param(value="id") UUID var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCase(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCase(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestCaseQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestCaseQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCaseByName(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCaseByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTestCaseByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTestCaseByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public TestCase deleteTestCaseResult(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> deleteTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase get3(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> get3WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase get3(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get3QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> get3WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get3QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestCase getSpecificTestCaseVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getSpecificTestCaseVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase getTestCaseByName(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase getTestCaseByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTestCaseByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTestCaseByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestCaseVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestCaseVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseResultList listTestCaseResults(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseResultList> listTestCaseResultsWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseResultList listTestCaseResults(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListTestCaseResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseResultList> listTestCaseResultsWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListTestCaseResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&orderByLastExecutionDate={orderByLastExecutionDate}&includeAllTests={includeAllTests}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCases(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="testSuiteId") String var6, @Param(value="orderByLastExecutionDate") Boolean var7, @Param(value="includeAllTests") Boolean var8, @Param(value="include") String var9);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&orderByLastExecutionDate={orderByLastExecutionDate}&includeAllTests={includeAllTests}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="testSuiteId") String var6, @Param(value="orderByLastExecutionDate") Boolean var7, @Param(value="includeAllTests") Boolean var8, @Param(value="include") String var9);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&orderByLastExecutionDate={orderByLastExecutionDate}&includeAllTests={includeAllTests}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCases(@QueryMap(encoded=true) ListTestCasesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&orderByLastExecutionDate={orderByLastExecutionDate}&includeAllTests={includeAllTests}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesWithHttpInfo(@QueryMap(encoded=true) ListTestCasesQueryParams var1);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTest(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestCaseResult(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2, Object var3);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2, Object var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase restore10(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> restore10WithHttpInfo(RestoreEntity var1);

    public static class ListTestCasesQueryParams
    extends HashMap<String, Object> {
        public ListTestCasesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams entityLink(String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams testSuiteId(String value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams orderByLastExecutionDate(Boolean value) {
            this.put("orderByLastExecutionDate", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams includeAllTests(Boolean value) {
            this.put("includeAllTests", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTestCaseResultsQueryParams
    extends HashMap<String, Object> {
        public ListTestCaseResultsQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCaseResultsQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestCaseByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestCaseByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestCaseByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get3QueryParams
    extends HashMap<String, Object> {
        public Get3QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get3QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestCaseByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestCaseByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestCaseQueryParams
    extends HashMap<String, Object> {
        public DeleteTestCaseQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

