/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateTopic;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Topic;
import org.openmetadata.client.model.TopicList;
import org.openmetadata.client.model.TopicSampleData;
import org.openmetadata.client.model.VoteRequest;

public interface TopicsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/topics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower6(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/topics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower6WithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/topics/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic addSampleData2(@Param(value="id") UUID var1, TopicSampleData var2);

    @RequestLine(value="PUT /v1/topics/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> addSampleData2WithHttpInfo(@Param(value="id") UUID var1, TopicSampleData var2);

    @RequestLine(value="PUT /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createOrUpdateTopic(CreateTopic var1);

    @RequestLine(value="PUT /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> createOrUpdateTopicWithHttpInfo(CreateTopic var1);

    @RequestLine(value="POST /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createTopic(CreateTopic var1);

    @RequestLine(value="POST /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> createTopicWithHttpInfo(CreateTopic var1);

    @RequestLine(value="DELETE /v1/topics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower7(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/topics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower7WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopic(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopic(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTopicQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTopicQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTopicByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic get7(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> get7WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic get7(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get7QueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> get7WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get7QueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Topic getSampleData2(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getSampleData2WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Topic getSpecificTopicVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/topics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getSpecificTopicVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getTopicByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getTopicByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTopicVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTopicVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TopicList listTopics(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TopicList> listTopicsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TopicList listTopics(@QueryMap(encoded=true) ListTopicsQueryParams var1);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TopicList> listTopicsWithHttpInfo(@QueryMap(encoded=true) ListTopicsQueryParams var1);

    @RequestLine(value="PATCH /v1/topics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTopic(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/topics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTopicWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/topics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic restore32(RestoreEntity var1);

    @RequestLine(value="PUT /v1/topics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> restore32WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/topics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity16(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/topics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity16WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListTopicsQueryParams
    extends HashMap<String, Object> {
        public ListTopicsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTopicByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTopicByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTopicByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get7QueryParams
    extends HashMap<String, Object> {
        public Get7QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get7QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

