/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"assets", "dryRun", "glossaryTags", "operation"})
public class AddGlossaryToAssetsRequest {
    public static final String JSON_PROPERTY_ASSETS = "assets";
    private List<EntityReference> assets;
    public static final String JSON_PROPERTY_DRY_RUN = "dryRun";
    private Boolean dryRun;
    public static final String JSON_PROPERTY_GLOSSARY_TAGS = "glossaryTags";
    private List<TagLabel> glossaryTags;
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private OperationEnum operation;

    public AddGlossaryToAssetsRequest assets(List<EntityReference> assets) {
        this.assets = assets;
        return this;
    }

    public AddGlossaryToAssetsRequest addAssetsItem(EntityReference assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<EntityReference>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssets(List<EntityReference> assets) {
        this.assets = assets;
    }

    public AddGlossaryToAssetsRequest dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Nullable
    @JsonProperty(value="dryRun")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public AddGlossaryToAssetsRequest glossaryTags(List<TagLabel> glossaryTags) {
        this.glossaryTags = glossaryTags;
        return this;
    }

    public AddGlossaryToAssetsRequest addGlossaryTagsItem(TagLabel glossaryTagsItem) {
        if (this.glossaryTags == null) {
            this.glossaryTags = new ArrayList<TagLabel>();
        }
        this.glossaryTags.add(glossaryTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="glossaryTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getGlossaryTags() {
        return this.glossaryTags;
    }

    @JsonProperty(value="glossaryTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGlossaryTags(List<TagLabel> glossaryTags) {
        this.glossaryTags = glossaryTags;
    }

    public AddGlossaryToAssetsRequest operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationEnum getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddGlossaryToAssetsRequest addGlossaryToAssetsRequest = (AddGlossaryToAssetsRequest)o;
        return Objects.equals(this.assets, addGlossaryToAssetsRequest.assets) && Objects.equals(this.dryRun, addGlossaryToAssetsRequest.dryRun) && Objects.equals(this.glossaryTags, addGlossaryToAssetsRequest.glossaryTags) && Objects.equals((Object)this.operation, (Object)addGlossaryToAssetsRequest.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assets, this.dryRun, this.glossaryTags, this.operation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddGlossaryToAssetsRequest {\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    glossaryTags: ").append(this.toIndentedString(this.glossaryTags)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        ADDASSETS("AddAssets"),
        ADDGLOSSARYTAGS("AddGlossaryTags");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

