/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ContainerDataModel;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"dataModel", "dataProducts", "description", "displayName", "domain", "extension", "fileFormats", "lifeCycle", "name", "numberOfObjects", "owner", "parent", "prefix", "service", "size", "sourceHash", "sourceUrl", "tags"})
public class CreateContainer {
    public static final String JSON_PROPERTY_DATA_MODEL = "dataModel";
    private ContainerDataModel dataModel;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_FILE_FORMATS = "fileFormats";
    private List<FileFormatsEnum> fileFormats;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NUMBER_OF_OBJECTS = "numberOfObjects";
    private Double numberOfObjects;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private EntityReference owner;
    public static final String JSON_PROPERTY_PARENT = "parent";
    private EntityReference parent;
    public static final String JSON_PROPERTY_PREFIX = "prefix";
    private String prefix;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Double size;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    private String sourceHash;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;

    public CreateContainer dataModel(ContainerDataModel dataModel) {
        this.dataModel = dataModel;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContainerDataModel getDataModel() {
        return this.dataModel;
    }

    @JsonProperty(value="dataModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataModel(ContainerDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public CreateContainer dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateContainer addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateContainer description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateContainer displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateContainer domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateContainer extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateContainer fileFormats(List<FileFormatsEnum> fileFormats) {
        this.fileFormats = fileFormats;
        return this;
    }

    public CreateContainer addFileFormatsItem(FileFormatsEnum fileFormatsItem) {
        if (this.fileFormats == null) {
            this.fileFormats = new ArrayList<FileFormatsEnum>();
        }
        this.fileFormats.add(fileFormatsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fileFormats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FileFormatsEnum> getFileFormats() {
        return this.fileFormats;
    }

    @JsonProperty(value="fileFormats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFormats(List<FileFormatsEnum> fileFormats) {
        this.fileFormats = fileFormats;
    }

    public CreateContainer lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateContainer name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateContainer numberOfObjects(Double numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfObjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNumberOfObjects() {
        return this.numberOfObjects;
    }

    @JsonProperty(value="numberOfObjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfObjects(Double numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    public CreateContainer owner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateContainer parent(EntityReference parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(EntityReference parent) {
        this.parent = parent;
    }

    public CreateContainer prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Nullable
    @JsonProperty(value="prefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty(value="prefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public CreateContainer service(String service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(String service) {
        this.service = service;
    }

    public CreateContainer size(Double size) {
        this.size = size;
        return this;
    }

    @Nullable
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Double size) {
        this.size = size;
    }

    public CreateContainer sourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateContainer sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateContainer tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateContainer addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateContainer createContainer = (CreateContainer)o;
        return Objects.equals(this.dataModel, createContainer.dataModel) && Objects.equals(this.dataProducts, createContainer.dataProducts) && Objects.equals(this.description, createContainer.description) && Objects.equals(this.displayName, createContainer.displayName) && Objects.equals(this.domain, createContainer.domain) && Objects.equals(this.extension, createContainer.extension) && Objects.equals(this.fileFormats, createContainer.fileFormats) && Objects.equals(this.lifeCycle, createContainer.lifeCycle) && Objects.equals(this.name, createContainer.name) && Objects.equals(this.numberOfObjects, createContainer.numberOfObjects) && Objects.equals(this.owner, createContainer.owner) && Objects.equals(this.parent, createContainer.parent) && Objects.equals(this.prefix, createContainer.prefix) && Objects.equals(this.service, createContainer.service) && Objects.equals(this.size, createContainer.size) && Objects.equals(this.sourceHash, createContainer.sourceHash) && Objects.equals(this.sourceUrl, createContainer.sourceUrl) && Objects.equals(this.tags, createContainer.tags);
    }

    public int hashCode() {
        return Objects.hash(this.dataModel, this.dataProducts, this.description, this.displayName, this.domain, this.extension, this.fileFormats, this.lifeCycle, this.name, this.numberOfObjects, this.owner, this.parent, this.prefix, this.service, this.size, this.sourceHash, this.sourceUrl, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateContainer {\n");
        sb.append("    dataModel: ").append(this.toIndentedString(this.dataModel)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    fileFormats: ").append(this.toIndentedString(this.fileFormats)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numberOfObjects: ").append(this.toIndentedString(this.numberOfObjects)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FileFormatsEnum {
        ZIP("zip"),
        GZ("gz"),
        ZSTD("zstd"),
        CSV("csv"),
        TSV("tsv"),
        JSON("json"),
        PARQUET("parquet"),
        AVRO("avro");

        private String value;

        private FileFormatsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatsEnum fromValue(String value) {
            for (FileFormatsEnum b : FileFormatsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

