/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MlModelConnection;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"connection", "dataProducts", "description", "displayName", "domain", "extension", "lifeCycle", "name", "owner", "serviceType", "tags"})
public class CreateMlModelService {
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private MlModelConnection connection;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private EntityReference owner;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;

    public CreateMlModelService connection(MlModelConnection connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MlModelConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(MlModelConnection connection) {
        this.connection = connection;
    }

    public CreateMlModelService dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateMlModelService addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateMlModelService description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMlModelService displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateMlModelService domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateMlModelService extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateMlModelService lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateMlModelService name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateMlModelService owner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateMlModelService serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public CreateMlModelService tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMlModelService addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMlModelService createMlModelService = (CreateMlModelService)o;
        return Objects.equals(this.connection, createMlModelService.connection) && Objects.equals(this.dataProducts, createMlModelService.dataProducts) && Objects.equals(this.description, createMlModelService.description) && Objects.equals(this.displayName, createMlModelService.displayName) && Objects.equals(this.domain, createMlModelService.domain) && Objects.equals(this.extension, createMlModelService.extension) && Objects.equals(this.lifeCycle, createMlModelService.lifeCycle) && Objects.equals(this.name, createMlModelService.name) && Objects.equals(this.owner, createMlModelService.owner) && Objects.equals((Object)this.serviceType, (Object)createMlModelService.serviceType) && Objects.equals(this.tags, createMlModelService.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connection, this.dataProducts, this.description, this.displayName, this.domain, this.extension, this.lifeCycle, this.name, this.owner, this.serviceType, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMlModelService {\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServiceTypeEnum {
        MLFLOW("Mlflow"),
        SKLEARN("Sklearn"),
        CUSTOMMLMODEL("CustomMlModel"),
        SAGEMAKER("SageMaker");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

