/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MlFeature;
import org.openmetadata.client.model.MlHyperParameter;
import org.openmetadata.client.model.MlStore;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"algorithm", "changeDescription", "children", "dashboard", "dataProducts", "deleted", "description", "displayName", "domain", "experts", "extension", "followers", "fullyQualifiedName", "href", "id", "lifeCycle", "mlFeatures", "mlHyperParameters", "mlStore", "name", "owner", "provider", "reviewers", "server", "service", "serviceType", "sourceHash", "sourceUrl", "style", "tags", "target", "updatedAt", "updatedBy", "usageSummary", "version", "votes"})
public class MlModel {
    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private String algorithm;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<EntityReference> children;
    public static final String JSON_PROPERTY_DASHBOARD = "dashboard";
    private EntityReference dashboard;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<EntityReference> dataProducts;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private Boolean deleted;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private EntityReference domain;
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    private List<EntityReference> experts;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    private List<EntityReference> followers;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_HREF = "href";
    private URI href;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_ML_FEATURES = "mlFeatures";
    private List<MlFeature> mlFeatures;
    public static final String JSON_PROPERTY_ML_HYPER_PARAMETERS = "mlHyperParameters";
    private List<MlHyperParameter> mlHyperParameters;
    public static final String JSON_PROPERTY_ML_STORE = "mlStore";
    private MlStore mlStore;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private EntityReference owner;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SERVER = "server";
    private URI server;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private EntityReference service;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    private String sourceHash;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_STYLE = "style";
    private Style style;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    private String updatedBy;
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Double version;
    public static final String JSON_PROPERTY_VOTES = "votes";
    private Votes votes;

    public MlModel algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nonnull
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public MlModel changeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public MlModel children(List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public MlModel addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<EntityReference> children) {
        this.children = children;
    }

    public MlModel dashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    @Nullable
    @JsonProperty(value="dashboard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDashboard() {
        return this.dashboard;
    }

    @JsonProperty(value="dashboard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
    }

    public MlModel dataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public MlModel addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public MlModel deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public MlModel description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public MlModel displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MlModel domain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public MlModel experts(List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public MlModel addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(List<EntityReference> experts) {
        this.experts = experts;
    }

    public MlModel extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public MlModel followers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public MlModel addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public MlModel fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MlModel href(URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(URI href) {
        this.href = href;
    }

    public MlModel id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public MlModel lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public MlModel mlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
        return this;
    }

    public MlModel addMlFeaturesItem(MlFeature mlFeaturesItem) {
        if (this.mlFeatures == null) {
            this.mlFeatures = new ArrayList<MlFeature>();
        }
        this.mlFeatures.add(mlFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="mlFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MlFeature> getMlFeatures() {
        return this.mlFeatures;
    }

    @JsonProperty(value="mlFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
    }

    public MlModel mlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
        return this;
    }

    public MlModel addMlHyperParametersItem(MlHyperParameter mlHyperParametersItem) {
        if (this.mlHyperParameters == null) {
            this.mlHyperParameters = new ArrayList<MlHyperParameter>();
        }
        this.mlHyperParameters.add(mlHyperParametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="mlHyperParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MlHyperParameter> getMlHyperParameters() {
        return this.mlHyperParameters;
    }

    @JsonProperty(value="mlHyperParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
    }

    public MlModel mlStore(MlStore mlStore) {
        this.mlStore = mlStore;
        return this;
    }

    @Nullable
    @JsonProperty(value="mlStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MlStore getMlStore() {
        return this.mlStore;
    }

    @JsonProperty(value="mlStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMlStore(MlStore mlStore) {
        this.mlStore = mlStore;
    }

    public MlModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public MlModel owner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public MlModel provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public MlModel reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public MlModel addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public MlModel server(URI server) {
        this.server = server;
        return this;
    }

    @Nullable
    @JsonProperty(value="server")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServer(URI server) {
        this.server = server;
    }

    public MlModel service(EntityReference service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(EntityReference service) {
        this.service = service;
    }

    public MlModel serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public MlModel sourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public MlModel sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public MlModel style(Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(Style style) {
        this.style = style;
    }

    public MlModel tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public MlModel addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public MlModel target(String target) {
        this.target = target;
        return this;
    }

    @Nullable
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(String target) {
        this.target = target;
    }

    public MlModel updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public MlModel updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public MlModel usageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public MlModel version(Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Double version) {
        this.version = version;
    }

    public MlModel votes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlModel mlModel = (MlModel)o;
        return Objects.equals(this.algorithm, mlModel.algorithm) && Objects.equals(this.changeDescription, mlModel.changeDescription) && Objects.equals(this.children, mlModel.children) && Objects.equals(this.dashboard, mlModel.dashboard) && Objects.equals(this.dataProducts, mlModel.dataProducts) && Objects.equals(this.deleted, mlModel.deleted) && Objects.equals(this.description, mlModel.description) && Objects.equals(this.displayName, mlModel.displayName) && Objects.equals(this.domain, mlModel.domain) && Objects.equals(this.experts, mlModel.experts) && Objects.equals(this.extension, mlModel.extension) && Objects.equals(this.followers, mlModel.followers) && Objects.equals(this.fullyQualifiedName, mlModel.fullyQualifiedName) && Objects.equals(this.href, mlModel.href) && Objects.equals(this.id, mlModel.id) && Objects.equals(this.lifeCycle, mlModel.lifeCycle) && Objects.equals(this.mlFeatures, mlModel.mlFeatures) && Objects.equals(this.mlHyperParameters, mlModel.mlHyperParameters) && Objects.equals(this.mlStore, mlModel.mlStore) && Objects.equals(this.name, mlModel.name) && Objects.equals(this.owner, mlModel.owner) && Objects.equals((Object)this.provider, (Object)mlModel.provider) && Objects.equals(this.reviewers, mlModel.reviewers) && Objects.equals(this.server, mlModel.server) && Objects.equals(this.service, mlModel.service) && Objects.equals((Object)this.serviceType, (Object)mlModel.serviceType) && Objects.equals(this.sourceHash, mlModel.sourceHash) && Objects.equals(this.sourceUrl, mlModel.sourceUrl) && Objects.equals(this.style, mlModel.style) && Objects.equals(this.tags, mlModel.tags) && Objects.equals(this.target, mlModel.target) && Objects.equals(this.updatedAt, mlModel.updatedAt) && Objects.equals(this.updatedBy, mlModel.updatedBy) && Objects.equals(this.usageSummary, mlModel.usageSummary) && Objects.equals(this.version, mlModel.version) && Objects.equals(this.votes, mlModel.votes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.changeDescription, this.children, this.dashboard, this.dataProducts, this.deleted, this.description, this.displayName, this.domain, this.experts, this.extension, this.followers, this.fullyQualifiedName, this.href, this.id, this.lifeCycle, this.mlFeatures, this.mlHyperParameters, this.mlStore, this.name, this.owner, this.provider, this.reviewers, this.server, this.service, this.serviceType, this.sourceHash, this.sourceUrl, this.style, this.tags, this.target, this.updatedAt, this.updatedBy, this.usageSummary, this.version, this.votes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MlModel {\n");
        sb.append("    algorithm: ").append(this.toIndentedString(this.algorithm)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    dashboard: ").append(this.toIndentedString(this.dashboard)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    mlFeatures: ").append(this.toIndentedString(this.mlFeatures)).append("\n");
        sb.append("    mlHyperParameters: ").append(this.toIndentedString(this.mlHyperParameters)).append("\n");
        sb.append("    mlStore: ").append(this.toIndentedString(this.mlStore)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM("system"),
        USER("user");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ServiceTypeEnum {
        MLFLOW("Mlflow"),
        SKLEARN("Sklearn"),
        CUSTOMMLMODEL("CustomMlModel"),
        SAGEMAKER("SageMaker");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

