/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ColumnProfilerConfig;
import org.openmetadata.client.model.PartitionProfilerConfig;

@JsonPropertyOrder(value={"excludeColumns", "includeColumns", "partitioning", "profileQuery", "profileSample", "profileSampleType", "sampleDataCount"})
public class TableProfilerConfig {
    public static final String JSON_PROPERTY_EXCLUDE_COLUMNS = "excludeColumns";
    private List<String> excludeColumns;
    public static final String JSON_PROPERTY_INCLUDE_COLUMNS = "includeColumns";
    private List<ColumnProfilerConfig> includeColumns;
    public static final String JSON_PROPERTY_PARTITIONING = "partitioning";
    private PartitionProfilerConfig partitioning;
    public static final String JSON_PROPERTY_PROFILE_QUERY = "profileQuery";
    private String profileQuery;
    public static final String JSON_PROPERTY_PROFILE_SAMPLE = "profileSample";
    private Double profileSample;
    public static final String JSON_PROPERTY_PROFILE_SAMPLE_TYPE = "profileSampleType";
    private ProfileSampleTypeEnum profileSampleType;
    public static final String JSON_PROPERTY_SAMPLE_DATA_COUNT = "sampleDataCount";
    private Integer sampleDataCount;

    public TableProfilerConfig excludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
        return this;
    }

    public TableProfilerConfig addExcludeColumnsItem(String excludeColumnsItem) {
        if (this.excludeColumns == null) {
            this.excludeColumns = new ArrayList<String>();
        }
        this.excludeColumns.add(excludeColumnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="excludeColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    @JsonProperty(value="excludeColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public TableProfilerConfig includeColumns(List<ColumnProfilerConfig> includeColumns) {
        this.includeColumns = includeColumns;
        return this;
    }

    public TableProfilerConfig addIncludeColumnsItem(ColumnProfilerConfig includeColumnsItem) {
        if (this.includeColumns == null) {
            this.includeColumns = new ArrayList<ColumnProfilerConfig>();
        }
        this.includeColumns.add(includeColumnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="includeColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ColumnProfilerConfig> getIncludeColumns() {
        return this.includeColumns;
    }

    @JsonProperty(value="includeColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeColumns(List<ColumnProfilerConfig> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public TableProfilerConfig partitioning(PartitionProfilerConfig partitioning) {
        this.partitioning = partitioning;
        return this;
    }

    @Nullable
    @JsonProperty(value="partitioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PartitionProfilerConfig getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty(value="partitioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitioning(PartitionProfilerConfig partitioning) {
        this.partitioning = partitioning;
    }

    public TableProfilerConfig profileQuery(String profileQuery) {
        this.profileQuery = profileQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="profileQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfileQuery() {
        return this.profileQuery;
    }

    @JsonProperty(value="profileQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileQuery(String profileQuery) {
        this.profileQuery = profileQuery;
    }

    public TableProfilerConfig profileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @Nullable
    @JsonProperty(value="profileSample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public TableProfilerConfig profileSampleType(ProfileSampleTypeEnum profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="profileSampleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProfileSampleTypeEnum getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileSampleType(ProfileSampleTypeEnum profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TableProfilerConfig sampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="sampleDataCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSampleDataCount() {
        return this.sampleDataCount;
    }

    @JsonProperty(value="sampleDataCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableProfilerConfig tableProfilerConfig = (TableProfilerConfig)o;
        return Objects.equals(this.excludeColumns, tableProfilerConfig.excludeColumns) && Objects.equals(this.includeColumns, tableProfilerConfig.includeColumns) && Objects.equals(this.partitioning, tableProfilerConfig.partitioning) && Objects.equals(this.profileQuery, tableProfilerConfig.profileQuery) && Objects.equals(this.profileSample, tableProfilerConfig.profileSample) && Objects.equals((Object)this.profileSampleType, (Object)tableProfilerConfig.profileSampleType) && Objects.equals(this.sampleDataCount, tableProfilerConfig.sampleDataCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.excludeColumns, this.includeColumns, this.partitioning, this.profileQuery, this.profileSample, this.profileSampleType, this.sampleDataCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableProfilerConfig {\n");
        sb.append("    excludeColumns: ").append(this.toIndentedString(this.excludeColumns)).append("\n");
        sb.append("    includeColumns: ").append(this.toIndentedString(this.includeColumns)).append("\n");
        sb.append("    partitioning: ").append(this.toIndentedString(this.partitioning)).append("\n");
        sb.append("    profileQuery: ").append(this.toIndentedString(this.profileQuery)).append("\n");
        sb.append("    profileSample: ").append(this.toIndentedString(this.profileSample)).append("\n");
        sb.append("    profileSampleType: ").append(this.toIndentedString((Object)this.profileSampleType)).append("\n");
        sb.append("    sampleDataCount: ").append(this.toIndentedString(this.sampleDataCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProfileSampleTypeEnum {
        PERCENTAGE("PERCENTAGE"),
        ROWS("ROWS");

        private String value;

        private ProfileSampleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProfileSampleTypeEnum fromValue(String value) {
            for (ProfileSampleTypeEnum b : ProfileSampleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

