/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"endpoint", "receivers", "secretKey", "sendToAdmins", "sendToFollowers", "sendToOwners"})
public class Webhook {
    public static final String JSON_PROPERTY_ENDPOINT = "endpoint";
    private URI endpoint;
    public static final String JSON_PROPERTY_RECEIVERS = "receivers";
    private Set<String> receivers;
    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    private String secretKey;
    public static final String JSON_PROPERTY_SEND_TO_ADMINS = "sendToAdmins";
    private Boolean sendToAdmins;
    public static final String JSON_PROPERTY_SEND_TO_FOLLOWERS = "sendToFollowers";
    private Boolean sendToFollowers;
    public static final String JSON_PROPERTY_SEND_TO_OWNERS = "sendToOwners";
    private Boolean sendToOwners;

    public Webhook endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nullable
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public Webhook receivers(Set<String> receivers) {
        this.receivers = receivers;
        return this;
    }

    public Webhook addReceiversItem(String receiversItem) {
        if (this.receivers == null) {
            this.receivers = new LinkedHashSet<String>();
        }
        this.receivers.add(receiversItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="receivers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getReceivers() {
        return this.receivers;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="receivers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceivers(Set<String> receivers) {
        this.receivers = receivers;
    }

    public Webhook secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Webhook sendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToAdmins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToAdmins() {
        return this.sendToAdmins;
    }

    @JsonProperty(value="sendToAdmins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
    }

    public Webhook sendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToFollowers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToFollowers() {
        return this.sendToFollowers;
    }

    @JsonProperty(value="sendToFollowers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
    }

    public Webhook sendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendToOwners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendToOwners() {
        return this.sendToOwners;
    }

    @JsonProperty(value="sendToOwners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.endpoint, webhook.endpoint) && Objects.equals(this.receivers, webhook.receivers) && Objects.equals(this.secretKey, webhook.secretKey) && Objects.equals(this.sendToAdmins, webhook.sendToAdmins) && Objects.equals(this.sendToFollowers, webhook.sendToFollowers) && Objects.equals(this.sendToOwners, webhook.sendToOwners);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.receivers, this.secretKey, this.sendToAdmins, this.sendToFollowers, this.sendToOwners);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    receivers: ").append(this.toIndentedString(this.receivers)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("    sendToAdmins: ").append(this.toIndentedString(this.sendToAdmins)).append("\n");
        sb.append("    sendToFollowers: ").append(this.toIndentedString(this.sendToFollowers)).append("\n");
        sb.append("    sendToOwners: ").append(this.toIndentedString(this.sendToOwners)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

