/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.APICollection;
import org.openmetadata.client.model.APICollectionList;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateAPICollection;
import org.openmetadata.client.model.Database;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface ApiCollectionsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database createAPICollection(CreateAPICollection var1);

    @RequestLine(value="POST /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Database> createAPICollectionWithHttpInfo(CreateAPICollection var1);

    @RequestLine(value="PUT /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APICollection createOrUpdateAPICollection(CreateAPICollection var1);

    @RequestLine(value="PUT /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APICollection> createOrUpdateAPICollectionWithHttpInfo(CreateAPICollection var1);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollection(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollection(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteAPICollectionQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteAPICollectionQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPICollectionByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetAPICollectionByIDQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetAPICollectionByIDQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public APICollection getSpecificAPICollectionVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getSpecificAPICollectionVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollectionList listAPICollections(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollectionList> listAPICollectionsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollectionList listAPICollections(@QueryMap(encoded=true) ListAPICollectionsQueryParams var1);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollectionList> listAPICollectionsWithHttpInfo(@QueryMap(encoded=true) ListAPICollectionsQueryParams var1);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllAPICollectionVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllAPICollectionVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="PATCH /v1/apiCollections/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPICollection(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPICollectionWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPICollection1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPICollection1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/apiCollections/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APICollection restore(RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiCollections/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APICollection> restoreWithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiCollections/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForAPICollection(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/apiCollections/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForAPICollectionWithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListAPICollectionsQueryParams
    extends HashMap<String, Object> {
        public ListAPICollectionsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPICollectionByIDQueryParams
    extends HashMap<String, Object> {
        public GetAPICollectionByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPICollectionByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPICollectionByFQNQueryParams
    extends HashMap<String, Object> {
        public GetAPICollectionByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPICollectionByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPICollectionByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteAPICollectionByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPICollectionByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPICollectionQueryParams
    extends HashMap<String, Object> {
        public DeleteAPICollectionQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPICollectionQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

