/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.APIEndpoint;
import org.openmetadata.client.model.APIEndpointList;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateAPIEndpoint;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Topic;
import org.openmetadata.client.model.VoteRequest;

public interface ApiEndpointApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/apiEndpoints/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIEndpoint createAPIEndpoint(CreateAPIEndpoint var1);

    @RequestLine(value="POST /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIEndpoint> createAPIEndpointWithHttpInfo(CreateAPIEndpoint var1);

    @RequestLine(value="PUT /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createOrUpdateAPIEndpoint(CreateAPIEndpoint var1);

    @RequestLine(value="PUT /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> createOrUpdateAPIEndpointWithHttpInfo(CreateAPIEndpoint var1);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpoint(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpoint(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerWithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetEndpointByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetEndpointByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointById(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByIdWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointById(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetEndpointByIdQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByIdWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetEndpointByIdQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getSpecificEndpointVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getSpecificEndpointVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpointList listAPIEndpoints(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="apiCollection") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpointList> listAPIEndpointsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="apiCollection") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpointList listAPIEndpoints(@QueryMap(encoded=true) ListAPIEndpointsQueryParams var1);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpointList> listAPIEndpointsWithHttpInfo(@QueryMap(encoded=true) ListAPIEndpointsQueryParams var1);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllAPIEndpointVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllAPIEndpointVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="PATCH /v1/apiEndpoints/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIEndpoint(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIEndpointWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIEndpoint1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIEndpoint1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/apiEndpoints/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIEndpoint restore1(RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiEndpoints/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIEndpoint> restore1WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForAPIEndpoint(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForAPIEndpointWithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListAPIEndpointsQueryParams
    extends HashMap<String, Object> {
        public ListAPIEndpointsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams apiCollection(String value) {
            this.put("apiCollection", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEndpointByIdQueryParams
    extends HashMap<String, Object> {
        public GetEndpointByIdQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetEndpointByIdQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEndpointByFQNQueryParams
    extends HashMap<String, Object> {
        public GetEndpointByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetEndpointByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

