/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.APIService;
import org.openmetadata.client.model.APIServiceList;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateAPIService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface ApiServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/apiServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIService addTestConnectionResult(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/apiServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIService> addTestConnectionResultWithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/apiServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIService createAPIService(CreateAPIService var1);

    @RequestLine(value="POST /v1/services/apiServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIService> createAPIServiceWithHttpInfo(CreateAPIService var1);

    @RequestLine(value="PUT /v1/services/apiServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIService createOrUpdateAPIService(CreateAPIService var1);

    @RequestLine(value="PUT /v1/services/apiServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIService> createOrUpdateAPIServiceWithHttpInfo(CreateAPIService var1);

    @RequestLine(value="DELETE /v1/services/apiServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIService(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/apiServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIServiceWithHttpInfo(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/apiServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIService(@Param(value="id") String var1, @QueryMap(encoded=true) DeleteAPIServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/apiServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIServiceWithHttpInfo(@Param(value="id") String var1, @QueryMap(encoded=true) DeleteAPIServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/apiServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIServiceByFQN(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/apiServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/apiServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIServiceByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIServiceByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/apiServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/apiServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIService getAPIServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/apiServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIService> getAPIServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/apiServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIService getAPIServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) GetAPIServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/apiServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIService> getAPIServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetAPIServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/apiServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIService getAPIServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/apiServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIService> getAPIServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/apiServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIService getAPIServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetAPIServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/apiServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIService> getAPIServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetAPIServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/apiServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public APIService getSpecificAPIServiceVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/apiServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIService> getSpecificAPIServiceVersionWithHttpInfo(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/apiServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIServiceList listAPIServices(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/apiServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIServiceList> listAPIServicesWithHttpInfo(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/apiServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIServiceList listAPIServices(@QueryMap(encoded=true) ListAPIServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/apiServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIServiceList> listAPIServicesWithHttpInfo(@QueryMap(encoded=true) ListAPIServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/apiServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllAPIServiceVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/apiServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllAPIServiceVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="PATCH /v1/services/apiServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIService(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/apiServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIServiceWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/apiServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIService1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/apiServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIService1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/apiServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIService restore22(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/apiServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIService> restore22WithHttpInfo(RestoreEntity var1);

    public static class ListAPIServicesQueryParams
    extends HashMap<String, Object> {
        public ListAPIServicesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIServicesQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIServicesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIServicesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIServicesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIServicesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPIServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetAPIServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPIServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPIServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetAPIServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPIServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIServiceByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPIServiceByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPIServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

