/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDashboardDataModel;
import org.openmetadata.client.model.DashboardDataModel;
import org.openmetadata.client.model.DashboardDataModelList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DashboardDataModelsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addFollowerToDataModel(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addFollowerToDataModelWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel createDataModel(CreateDashboardDataModel var1);

    @RequestLine(value="POST /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> createDataModelWithHttpInfo(CreateDashboardDataModel var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel createOrUpdateDataModel(CreateDashboardDataModel var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> createOrUpdateDataModelWithHttpInfo(CreateDashboardDataModel var1);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModel(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModel(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDataModelQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDataModelQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDataModelByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDataModelByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public void deleteFollowerFromDataModel(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFollowerFromDataModelWithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDataModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDataModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDataModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDataModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getSpecificDataModelVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getSpecificDataModelVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDataModelVersions(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDataModelVersionsWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModelList listDashboardDataModels(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModelList> listDashboardDataModelsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModelList listDashboardDataModels(@QueryMap(encoded=true) ListDashboardDataModelsQueryParams var1);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModelList> listDashboardDataModelsWithHttpInfo(@QueryMap(encoded=true) ListDashboardDataModelsQueryParams var1);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataModel(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataModelWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataModel1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataModel1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel restore11(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> restore11WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity6(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity6WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListDashboardDataModelsQueryParams
    extends HashMap<String, Object> {
        public ListDashboardDataModelsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelByIDQueryParams
    extends HashMap<String, Object> {
        public GetDataModelByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDataModelByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataModelByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDataModelByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataModelByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataModelQueryParams
    extends HashMap<String, Object> {
        public DeleteDataModelQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataModelQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

